/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.jcplugin;

import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jomcraft.jcplugin.JCLogger;
import net.jomcraft.jcplugin.MainJSON;
import net.jomcraft.jcplugin.PrivateJSON;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.Level;

public class FileUtilNoMC {
    public static File mcDataDir = null;
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static MainJSON mainJson;
    public static PrivateJSON privateJson;
    public static volatile boolean options_exists;
    public static volatile boolean keys_exists;
    public static ArrayList<String> deleted;
    public static volatile boolean servers_exists;
    public static String activeProfile;
    public static boolean otherCreator;
    public static final FileFilter fileFilterModular;
    public static final FileFilter fileFilterAnti;
    public static final FileFilter fileFilter;
    public static final ArrayList<String> optUse;

    public static File getMainFolder() {
        File storeFolder = new File(mcDataDir, "config/defaultsettings");
        storeFolder.mkdir();
        return storeFolder;
    }

    public static void setActive(String name, boolean active) {
        mainJson.save();
    }

    public static void switchActive(String name) {
        mainJson.save();
    }

    public static void initialSetupJSON() throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        FileUtilNoMC.getPrivateJSON();
        FileUtilNoMC.getMainJSON();
        if (!FileUtilNoMC.privateJson.privateIdentifier.equals(FileUtilNoMC.mainJson.generatedBy) && !FileUtilNoMC.mainJson.generatedBy.equals("<default>")) {
            otherCreator = true;
        }
        mainJson.save();
    }

    public static PrivateJSON getPrivateJSON() {
        if (privateJson != null) {
            return privateJson;
        }
        File privateFile = new File(mcDataDir, "ds_private_storage.json");
        if (privateFile.exists()) {
            try (FileReader reader = new FileReader(privateFile);){
                privateJson = (PrivateJSON)gson.fromJson((Reader)reader, PrivateJSON.class);
                if (FileUtilNoMC.privateJson.privateIdentifier == null || FileUtilNoMC.privateJson.privateIdentifier.isEmpty()) {
                    FileUtilNoMC.privateJson.privateIdentifier = UUID.randomUUID().toString();
                }
                privateJson.save();
            }
            catch (Exception e) {
                JCLogger.log.log(Level.ERROR, "Exception at processing startup: ", (Throwable)e);
            }
        } else {
            privateJson = new PrivateJSON();
            FileUtilNoMC.privateJson.privateIdentifier = UUID.randomUUID().toString();
            privateJson.save();
        }
        return privateJson;
    }

    public static MainJSON getMainJSON() {
        block10: {
            if (mainJson != null) {
                return mainJson;
            }
            File mainFile = new File(mcDataDir, "config/defaultsettings.json");
            if (mainFile.exists()) {
                try (FileReader reader = new FileReader(mainFile);){
                    mainJson = (MainJSON)gson.fromJson((Reader)reader, MainJSON.class);
                    break block10;
                }
                catch (Exception e) {
                    JCLogger.log.log(Level.ERROR, "Exception at processing configs: ", (Throwable)e);
                    if (e instanceof JsonSyntaxException) {
                        mainFile.renameTo(new File(mcDataDir, "config/defaultsettings_malformed.json"));
                        FileUtilNoMC.getMainJSON();
                    }
                    break block10;
                }
            }
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            mainJson = new MainJSON().setVersion("none").setCreated(formatter.format(date));
            mainJson.save();
        }
        return mainJson;
    }

    public static void restoreContentsFirst() throws NullPointerException, IOException, NoSuchAlgorithmException {
        new File(mcDataDir, "config").mkdir();
        boolean init = false;
        File privateFile = new File(mcDataDir, "ds_private_storage.json");
        if (!privateFile.exists()) {
            init = true;
        }
        FileUtilNoMC.initialSetupJSON();
        FileUtilNoMC.initialToDefaultProfile();
        String firstFolder = "<ERROR>";
        for (File file : FileUtilNoMC.getMainFolder().listFiles()) {
            if (!file.isDirectory() || file.getName().equals("sharedConfigs")) continue;
            firstFolder = file.getName();
            break;
        }
        if (!new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.mainJson.mainProfile).exists()) {
            FileUtilNoMC.mainJson.mainProfile = firstFolder;
        }
        if (FileUtilNoMC.privateJson.targetProfile.equals("!NEW!")) {
            FileUtilNoMC.privateJson.targetProfile = FileUtilNoMC.mainJson.mainProfile;
        }
        if (FileUtilNoMC.privateJson.currentProfile.equals("!NEW!")) {
            FileUtilNoMC.privateJson.currentProfile = FileUtilNoMC.mainJson.mainProfile;
        }
        if (!new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.privateJson.targetProfile).exists()) {
            FileUtilNoMC.privateJson.targetProfile = firstFolder;
        }
        if (!new File(FileUtilNoMC.getMainFolder(), FileUtilNoMC.privateJson.currentProfile).exists()) {
            FileUtilNoMC.privateJson.currentProfile = firstFolder;
        }
        privateJson.save();
        mainJson.save();
        boolean switchProf = FileUtilNoMC.switchProfile();
        activeProfile = FileUtilNoMC.privateJson.currentProfile;
        if (!init) {
            FileUtilNoMC.privateJson.firstBootUp = false;
            privateJson.save();
        }
        if (FileUtilNoMC.privateJson.firstBootUp && init) {
            FileUtilNoMC.restoreConfigs();
            FileUtilNoMC.privateJson.firstBootUp = false;
            privateJson.save();
        } else if (switchProf) {
            FileUtilNoMC.restoreConfigs();
            mainJson.save();
        } else {
            FileUtilNoMC.copyAndHashPrivate(true, true);
            mainJson.save();
        }
    }

    private static boolean switchProfile() throws IOException {
        if (FileUtilNoMC.mainJson.generatedBy.equals("<default>")) {
            FileUtilNoMC.mainJson.generatedBy = FileUtilNoMC.privateJson.privateIdentifier;
        }
        if (!FileUtilNoMC.privateJson.currentProfile.equals(FileUtilNoMC.privateJson.targetProfile)) {
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH.mm.ss");
            String profileName = formatter.format(date);
            final File fileDir = new File(FileUtilNoMC.getMainFolder(), profileName);
            fileDir.mkdir();
            activeProfile = profileName;
            FileUtilNoMC.moveAllConfigs();
            FileUtilNoMC.checkMD5(true, false, null);
            String[] extensions = new String[]{"zip"};
            List oldestFiles = Collections.emptyList();
            Collection files = FileUtils.listFiles((File)FileUtilNoMC.getMainFolder(), (String[])extensions, (boolean)false);
            if (files.size() >= 10) {
                List list2 = files.stream().map(File::toPath).collect(Collectors.toList());
                Comparator lastModifiedComparator = (p1, p2) -> Long.compare(p1.toFile().lastModified(), p2.toFile().lastModified());
                try (Stream paths = list2.stream();){
                    oldestFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(lastModifiedComparator).limit(files.size() - 8).collect(Collectors.toList());
                    oldestFiles.stream().forEach(t -> {
                        try {
                            Files.delete(t);
                        }
                        catch (IOException e) {
                            JCLogger.log.log(Level.ERROR, "Exception while processing profiles: ", (Throwable)e);
                        }
                    });
                }
            }
            Path pf = new File(FileUtilNoMC.getMainFolder(), profileName + ".zip").toPath();
            Files.createFile(pf, new FileAttribute[0]);
            try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(pf, new OpenOption[0]));){
                Path pt = Paths.get(fileDir.getPath(), new String[0]);
                Files.walk(pt, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(pt.relativize((Path)path).toString());
                    try {
                        zos.putNextEntry(zipEntry);
                        Files.copy(path, zos);
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        JCLogger.log.log(Level.ERROR, "Exception while processing profiles: ", (Throwable)e);
                    }
                });
            }
            try {
                deleted.add(fileDir.getName());
                FileUtils.deleteDirectory((File)fileDir);
            }
            catch (IOException e) {
                Thread thread = new Thread("File deletion thread"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10000L);
                            FileUtils.deleteDirectory((File)fileDir);
                        }
                        catch (IOException | InterruptedException exception) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
                try {
                    FileUtils.forceDeleteOnExit((File)fileDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            FileUtilNoMC.privateJson.currentProfile = activeProfile = FileUtilNoMC.privateJson.targetProfile;
            privateJson.save();
            return true;
        }
        return false;
    }

    private static void initialToDefaultProfile() {
        if (FileUtilNoMC.getMainJSON().mainProfile.equals("!NEW!")) {
            new File(FileUtilNoMC.getMainFolder(), "Default").mkdir();
            FileFilter ffm = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("Default");
                }
            };
            try {
                FileUtils.copyDirectory((File)FileUtilNoMC.getMainFolder(), (File)new File(FileUtilNoMC.getMainFolder(), "Default"), (FileFilter)ffm);
            }
            catch (IOException e) {
                JCLogger.log.log(Level.ERROR, "Couldn't move config files: ", (Throwable)e);
            }
            for (File f : FileUtilNoMC.getMainFolder().listFiles(ffm)) {
                try {
                    if (f.isDirectory()) {
                        FileUtils.deleteDirectory((File)f);
                        continue;
                    }
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    JCLogger.log.log(Level.ERROR, "Couldn't move config files: ", (Throwable)e);
                }
            }
            FileUtilNoMC.privateJson.targetProfile = "Default";
            privateJson.save();
            FileUtilNoMC.getMainJSON().mainProfile = "Default";
            mainJson.save();
        }
        String firstFolder = "<ERROR>";
        for (File file : FileUtilNoMC.getMainFolder().listFiles()) {
            if (!file.isDirectory() || file.getName().equals("sharedConfigs")) continue;
            firstFolder = file.getName();
            break;
        }
        if (firstFolder.equals("<ERROR>")) {
            new File(FileUtilNoMC.getMainFolder(), "Default").mkdir();
            FileUtilNoMC.privateJson.targetProfile = "Default";
            privateJson.save();
            FileUtilNoMC.getMainJSON().mainProfile = "Default";
            mainJson.save();
        }
        File shared = new File(FileUtilNoMC.getMainFolder(), "sharedConfigs");
        shared.mkdir();
    }

    public static void copyAndHashPrivate(boolean options, boolean configs) throws NullPointerException, IOException {
        ArrayList toRemove = new ArrayList();
        if (options) {
            for (String opt : optUse) {
                File optFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/" + opt);
                if (!optFile.exists() || FileUtilNoMC.privateJson.currentHash.containsKey(activeProfile + "/" + opt) && (!FileUtilNoMC.mainJson.hashes.containsKey(activeProfile + "/" + opt) || FileUtilNoMC.privateJson.currentHash.get(activeProfile + "/" + opt).equals(FileUtilNoMC.mainJson.hashes.get(activeProfile + "/" + opt)))) continue;
                if (opt.equals("options.txt")) {
                    FileUtilNoMC.restoreOptions();
                } else if (opt.equals("optionsof.txt")) {
                    FileUtilNoMC.restoreOptionsOF();
                } else if (opt.equals("optionsshaders.txt")) {
                    FileUtilNoMC.restoreOptionsShaders();
                } else if (opt.equals("options.justenoughkeys.txt")) {
                    FileUtilNoMC.restoreOptionsJEK();
                } else if (opt.equals("options.amecsapi.txt")) {
                    FileUtilNoMC.restoreOptionsAmecs();
                } else if (opt.equals("servers.dat")) {
                    FileUtilNoMC.restoreServers();
                }
                FileUtilNoMC.privateJson.currentHash.put(activeProfile + "/" + opt, FileUtilNoMC.mainJson.hashes.get(activeProfile + "/" + opt));
            }
        }
        if (configs) {
            File filec = new File(mcDataDir, "config");
            Collection config = FileUtils.listFilesAndDirs((File)new File(FileUtilNoMC.getMainFolder(), activeProfile), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File configFile : config) {
                String relativePath;
                String pathString;
                if (configFile.isDirectory() || configFile.getName().contains("defaultsettings") || configFile.getName().equals("ignore.json") || optUse.contains(configFile.getName()) || FileUtilNoMC.privateJson.currentHash.containsKey(pathString = activeProfile + "/" + (relativePath = configFile.getPath().substring(mcDataDir.getPath().length())).split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1)) && (!FileUtilNoMC.mainJson.hashes.containsKey(pathString) || FileUtilNoMC.privateJson.currentHash.get(pathString).equals(FileUtilNoMC.mainJson.hashes.get(pathString))) || !FileUtilNoMC.mainJson.hashes.containsKey(pathString)) continue;
                FileUtils.copyFile((File)configFile, (File)new File(filec, relativePath.split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1)));
                FileUtilNoMC.privateJson.currentHash.put(pathString, FileUtilNoMC.mainJson.hashes.get(pathString));
            }
        }
        privateJson.save();
        if (toRemove.size() > 0) {
            mainJson.save();
        }
    }

    public static boolean optionsFilesExist() {
        File optionsFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.txt");
        File optionsofFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/optionsof.txt");
        File optionsShadersFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/optionsshaders.txt");
        File optionsJEKFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.justenoughkeys.txt");
        File optionsAmecsFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.amecsapi.txt");
        return optionsFile.exists() || optionsofFile.exists() || optionsShadersFile.exists() || optionsJEKFile.exists() || optionsAmecsFile.exists();
    }

    public static boolean keysFileExist() {
        File keysFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/keys.txt");
        return keysFile.exists();
    }

    public static void deleteKeys() {
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/keys.txt").delete();
        keys_exists = false;
    }

    public static void deleteServers() {
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/servers.dat").delete();
        servers_exists = false;
    }

    public static void deleteOptions() {
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.txt").delete();
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/optionsof.txt").delete();
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/optionsshaders.txt").delete();
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.justenoughkeys.txt").delete();
        new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.amecsapi.txt").delete();
        options_exists = false;
    }

    public static void restoreOptions() throws NullPointerException, IOException {
        File optionsFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.txt");
        if (optionsFile.exists()) {
            BufferedReader readerOptions = null;
            BufferedReader reader = null;
            PrintWriter writer = null;
            File opFile = new File(mcDataDir, "options.txt");
            boolean existed = false;
            ArrayList<String> list = new ArrayList<String>();
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsFile));
                if (opFile.exists()) {
                    String lineOptions;
                    existed = true;
                    readerOptions = new BufferedReader(new FileReader(opFile));
                    while ((lineOptions = readerOptions.readLine()) != null) {
                        if (!lineOptions.startsWith("key_")) continue;
                        list.add(lineOptions);
                    }
                }
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "options.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
                for (String entry : list) {
                    writer.print(entry + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                    if (existed) {
                        readerOptions.close();
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreOptionsOF() throws IOException {
        File optionsOFFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/optionsof.txt");
        if (optionsOFFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsOFFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "optionsof.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreOptionsShaders() throws IOException {
        File optionsShadersFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/optionsshaders.txt");
        if (optionsShadersFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsShadersFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "optionsshaders.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreOptionsJEK() throws IOException {
        File optionsJEKFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.justenoughkeys.txt");
        if (optionsJEKFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsJEKFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "options.justenoughkeys.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreOptionsAmecs() throws IOException {
        File optionsJEKFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.amecsapi.txt");
        if (optionsJEKFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsJEKFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "options.amecsapi.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreConfigs() throws IOException {
        FileUtils.copyDirectory((File)new File(FileUtilNoMC.getMainFolder(), activeProfile), (File)new File(mcDataDir, "config"), (FileFilter)fileFilterModular);
        optUse.stream().map(file -> new File(FileUtilNoMC.getMainFolder(), activeProfile + "/" + file)).filter(file -> file.exists()).forEach(file -> {
            try {
                FileUtils.copyFile((File)file, (File)new File(mcDataDir, file.getName()));
            }
            catch (IOException e) {
                JCLogger.log.log(Level.ERROR, "Process the files: ", (Throwable)e);
            }
        });
        FileUtils.copyDirectory((File)new File(FileUtilNoMC.getMainFolder(), "sharedConfigs/"), (File)new File(mcDataDir, "config"), (FileFilter)fileFilterModular);
        FileUtils.listFilesAndDirs((File)new File(FileUtilNoMC.getMainFolder(), activeProfile), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(file -> !file.isDirectory()).forEach(file -> {
            try {
                FileUtilNoMC.privateJson.currentHash.put(activeProfile + "/" + file.getName(), FileUtilNoMC.fileToHash(new FileInputStream((File)file)));
            }
            catch (IOException e) {
                JCLogger.log.log(Level.ERROR, "Process the files: ", (Throwable)e);
            }
        });
        mainJson.save();
        privateJson.save();
    }

    public static void moveAllConfigs() throws IOException {
        FileUtils.copyDirectory((File)new File(FileUtilNoMC.getMainFolder(), activeProfile), (File)new File(mcDataDir, "config"), (FileFilter)fileFilterAnti);
        mainJson.save();
    }

    public static void restoreServers() throws IOException {
        try {
            File file = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/servers.dat");
            if (file.exists()) {
                FileUtils.copyFile((File)file, (File)new File(mcDataDir, "servers.dat"));
            } else {
                JCLogger.log.log(Level.WARN, "Couldn't restore the server config as it's not included");
            }
        }
        catch (IOException e) {
            JCLogger.log.log(Level.ERROR, "Couldn't restore the server config: ", (Throwable)e);
        }
    }

    public static void saveServers() throws IOException {
        File serversFile = new File(mcDataDir, "servers.dat");
        if (serversFile.exists()) {
            FileUtils.copyFile((File)serversFile, (File)new File(FileUtilNoMC.getMainFolder(), activeProfile + "/servers.dat"));
        }
    }

    public static InputStream getServersStream() throws IOException {
        File serversFile = new File(mcDataDir, "servers.dat");
        if (serversFile.exists()) {
            return new FileInputStream(serversFile);
        }
        return null;
    }

    public static InputStream getOptionsOFStream() throws IOException {
        File optionsFile = new File(mcDataDir, "optionsof.txt");
        if (optionsFile.exists()) {
            return new FileInputStream(optionsFile);
        }
        return null;
    }

    public static InputStream getOptionsShadersStream() throws IOException {
        File optionsFile = new File(mcDataDir, "optionsof.txt");
        if (optionsFile.exists()) {
            return new FileInputStream(optionsFile);
        }
        return null;
    }

    public static InputStream getOptionsJEKStream() throws IOException {
        File optionsFile = new File(mcDataDir, "options.justenoughkeys.txt");
        if (optionsFile.exists()) {
            return new FileInputStream(optionsFile);
        }
        return null;
    }

    public static InputStream getOptionsAmecsStream() throws IOException {
        File optionsFile = new File(mcDataDir, "options.amecsapi.txt");
        if (optionsFile.exists()) {
            return new FileInputStream(optionsFile);
        }
        return null;
    }

    public static InputStream getOptionsStream() throws IOException, NullPointerException {
        File keysFile = new File(mcDataDir, "options.txt");
        FileInputStream stream = null;
        if (keysFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            File file = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/options.txt_temp");
            try {
                String line;
                writer = new PrintWriter(new FileWriter(file));
                reader = new BufferedReader(new FileReader(keysFile));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("key_")) continue;
                    writer.print(line + "\n");
                }
                stream = new FileInputStream(file);
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
            return stream;
        }
        return null;
    }

    public static boolean serversFileExists() {
        File serversFile = new File(FileUtilNoMC.getMainFolder(), activeProfile + "/servers.dat");
        return serversFile.exists();
    }

    public static String stringToHash(String string) throws NoSuchAlgorithmException {
        return DigestUtils.md5Hex((String)string).toUpperCase();
    }

    public static String byteToHash(byte[] array) throws NoSuchAlgorithmException {
        return Hashing.sha256().hashBytes(array).toString();
    }

    public static String fileToHash(InputStream is) throws IOException {
        return DigestUtils.md5Hex((InputStream)is).toUpperCase();
    }

    public static boolean checkForConfigFiles() {
        try {
            Collection config = FileUtils.listFilesAndDirs((File)new File(FileUtilNoMC.getMainFolder(), activeProfile), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File configFile : config) {
                if (configFile.getName().equals(activeProfile) || configFile.getName().contains("defaultsettings") || optUse.contains(configFile.getName())) continue;
                return false;
            }
        }
        catch (Exception e) {
            JCLogger.log.log(Level.ERROR, "Error while saving configs: ", (Throwable)e);
        }
        return true;
    }

    public static boolean checkChangedConfig() {
        boolean ret = false;
        try {
            Collection config = FileUtils.listFilesAndDirs((File)new File(FileUtilNoMC.getMainFolder(), activeProfile), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File configFile : config) {
                String writtenHashS;
                String hashC;
                String relativePath;
                String pathString;
                if (configFile.isDirectory() || configFile.getName().equals("ignore.json") || configFile.getName().contains("defaultsettings") || optUse.contains(configFile.getName()) || !FileUtilNoMC.mainJson.hashes.containsKey(pathString = activeProfile + "/" + (relativePath = configFile.getPath().substring(mcDataDir.getPath().length())).split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1)) || (hashC = FileUtilNoMC.fileToHash(new FileInputStream(configFile))).equals(writtenHashS = FileUtilNoMC.mainJson.hashes.get(pathString))) continue;
                ret = true;
            }
        }
        catch (Exception e) {
            JCLogger.log.log(Level.ERROR, "Error while saving configs: ", (Throwable)e);
        }
        return ret;
    }

    public static ArrayList<String> listConfigFiles() throws FileNotFoundException, IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (File configFile : new File(FileUtilNoMC.getMainFolder(), activeProfile).listFiles()) {
            if (configFile.getName().equals("ignore.json") || configFile.getName().contains("defaultsettings") || optUse.contains(configFile.getName())) continue;
            String relativePath = configFile.getPath().substring(mcDataDir.getPath().length());
            String pathString = relativePath.split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1);
            files.add(pathString);
        }
        return files;
    }

    public static void checkMD5(boolean updateExisting, boolean configs, String file) throws IOException {
        ArrayList<File> fileList = null;
        File dir = new File(FileUtilNoMC.getMainFolder(), activeProfile);
        if (file == null) {
            fileList = new ArrayList<File>(FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE));
        } else {
            File directory = new File(dir, file);
            if (!directory.exists()) {
                WildcardFileFilter fileWildcard = new WildcardFileFilter(file);
                File[] locs = dir.listFiles((FileFilter)fileWildcard);
                fileList = new ArrayList();
                for (File loc : locs) {
                    if (loc.isDirectory()) {
                        for (File f : FileUtils.listFilesAndDirs((File)loc, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
                            fileList.add(f);
                        }
                        continue;
                    }
                    fileList.add(loc);
                }
            } else if (directory.isDirectory()) {
                fileList = new ArrayList(FileUtils.listFilesAndDirs((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE));
            } else {
                ArrayList<File> files = new ArrayList<File>();
                files.add(directory);
                fileList = files;
            }
        }
        for (File configFile : fileList) {
            if (configFile.isDirectory() || configFile.getName().equals("ignore.json") || configFile.getName().contains("defaultsettings") || optUse.contains(configFile.getName()) && configs) continue;
            String relativePath = configFile.getPath().substring(mcDataDir.getPath().length());
            String pathString = activeProfile + "/" + relativePath.split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1);
            if (!updateExisting && FileUtilNoMC.mainJson.hashes.containsKey(pathString)) continue;
            FileUtilNoMC.mainJson.hashes.put(pathString, FileUtilNoMC.fileToHash(new FileInputStream(configFile)));
        }
        mainJson.save();
    }

    static {
        options_exists = false;
        keys_exists = false;
        deleted = new ArrayList();
        servers_exists = false;
        activeProfile = "Default";
        otherCreator = false;
        fileFilterModular = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("sharedConfigs") && !file.getName().equals("ignore.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("optionsshaders.txt") && !file.getName().equals("options.justenoughkeys.txt") && !file.getName().equals("options.amecsapi.txt") && !file.getName().equals("servers.dat");
            }
        };
        fileFilterAnti = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("sharedConfigs") && !file.getName().equals("ignore.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("optionsshaders.txt") && !file.getName().equals("options.justenoughkeys.txt") && !file.getName().equals("options.amecsapi.txt") && !file.getName().equals("servers.dat");
            }
        };
        fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("optionsshaders.txt") && !file.getName().equals("options.justenoughkeys.txt") && !file.getName().equals("options.amecsapi.txt") && !file.getName().equals("servers.dat") && !new File(FileUtilNoMC.getMainFolder(), "sharedConfigs/" + file.getName()).exists();
            }
        };
        optUse = new ArrayList<String>(){
            private static final long serialVersionUID = -6765486158086901202L;
            {
                this.add("options.txt");
                this.add("servers.dat");
                this.add("optionsof.txt");
                this.add("optionsshaders.txt");
                this.add("options.justenoughkeys.txt");
                this.add("options.amecsapi.txt");
                this.add("keys.txt");
            }
        };
    }
}

