/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AwningBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BuzzierBeesCompat;
import net.mehvahdjukaar.supplementaries.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class RegUtils {
    protected static final BlockBehaviour.StatePredicate NEVER = (state, reader, pos) -> false;

    public static void initDynamicRegistry() {
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
        AdditionalItemPlacementsAPI.addRegistration(RegUtils::registerPlacements);
    }

    private static void registerPlacements(AdditionalItemPlacementsAPI.Event event) {
        if (CommonConfigs.Tweaks.WRITTEN_BOOKS.get().booleanValue()) {
            SuppAdditionalPlacement horizontalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE_H.get());
            event.register(Items.f_42517_, (AdditionalItemPlacement)horizontalPlacement);
            event.register(Items.f_42614_, (AdditionalItemPlacement)horizontalPlacement);
            event.register(Items.f_42615_, (AdditionalItemPlacement)horizontalPlacement);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_BOOKS.get().booleanValue()) {
            Item gene;
            SuppAdditionalPlacement verticalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE.get());
            event.register(Items.f_42690_, (AdditionalItemPlacement)verticalPlacement);
            Item tome = CompatObjects.TOME.get();
            if (tome != null) {
                event.register(tome, (AdditionalItemPlacement)verticalPlacement);
            }
            if ((gene = CompatObjects.GENE_BOOK.get()) != null) {
                event.register(gene, (AdditionalItemPlacement)verticalPlacement);
            }
        }
        event.registerSimple(ModRegistry.PANCAKE_ITEM.get(), ModRegistry.PANCAKE.get());
        if (CommonConfigs.Tweaks.PLACEABLE_STICKS.get().booleanValue()) {
            event.register(Items.f_42398_, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.STICK_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_RODS.get().booleanValue()) {
            event.register(Items.f_42585_, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.BLAZE_ROD_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            event.register(Items.f_42403_, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.GUNPOWDER_BLOCK.get()));
        }
        if (CommonConfigs.Tools.LUNCH_BOX_PLACEABLE.get().booleanValue()) {
            event.register((Item)ModRegistry.LUNCH_BASKET_ITEM.get(), new AdditionalItemPlacement(ModRegistry.LUNCH_BASKET.get()){

                public InteractionResult overrideUseOn(UseOnContext pContext, FoodProperties foodProperties) {
                    if (!pContext.m_43723_().m_36341_()) {
                        return InteractionResult.PASS;
                    }
                    return super.overrideUseOn(pContext, foodProperties);
                }
            });
        }
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return RegUtils.regWithItem(name, blockFactory, 0);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, int burnTime) {
        return RegUtils.regWithItem(name, blockFactory, new Item.Properties(), burnTime);
    }

    public static <T extends Block> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties, int burnTime) {
        RegSupplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static RegSupplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties, int burnTime) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), () -> burnTime == 0 ? new BlockItem((Block)blockSup.get(), properties) : new WoodBasedBlockItem((Block)blockSup.get(), properties, burnTime));
    }

    public static Map<DyeColor, Supplier<Block>> registerCandleHolders(ResourceLocation baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_284310_().m_60910_().m_278166_(PushReaction.DESTROY).m_60955_().m_60966_().m_60918_(SoundType.f_56762_);
        RegSupplier block = RegHelper.registerBlockWithItem((ResourceLocation)baseName, () -> new CandleHolderBlock(null, prop));
        map.put(null, block);
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName.m_135815_() + "_" + color.m_41065_();
            RegSupplier coloredBlock = RegHelper.registerBlockWithItem((ResourceLocation)new ResourceLocation(baseName.m_135827_(), name), () -> new CandleHolderBlock(color, prop));
            map.put(color, coloredBlock);
        }
        ModRegistry.ALL_CANDLE_HOLDERS.addAll(map.values());
        if (CompatHandler.BUZZIER_BEES) {
            BuzzierBeesCompat.registerCandle(baseName);
        }
        if (CompatHandler.CAVE_ENHANCEMENTS) {
            CaveEnhancementsCompat.registerCandle(baseName);
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerFlags(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.m_41065_();
            RegSupplier<Block> block = RegUtils.regBlock(name, () -> new FlagBlock(color, BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(color.m_284406_()).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56736_)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new FlagItem((Block)block.get(), new Item.Properties().m_41487_(16)));
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerPresents(String baseName, BiFunction<DyeColor, BlockBehaviour.Properties, Block> presentFactory, BiFunction<Block, Item.Properties, PresentItem> itemFactory) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<Block> block = RegUtils.regBlock(baseName, () -> (Block)presentFactory.apply(null, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278166_(PushReaction.DESTROY).m_60978_(0.5f).m_60918_((SoundType)ModSounds.PRESENT)));
        map.put(null, block);
        RegUtils.regItem(baseName, () -> (PresentItem)((Object)((Object)itemFactory.apply((Block)block.get(), new Item.Properties()))));
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.m_41065_();
            RegSupplier<Block> bb = RegUtils.regBlock(name, () -> (Block)presentFactory.apply(color, BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_278166_(PushReaction.DESTROY).m_60978_(0.5f).m_60918_((SoundType)ModSounds.PRESENT)));
            map.put(color, bb);
            RegUtils.regItem(name, () -> (PresentItem)((Object)((Object)itemFactory.apply((Block)bb.get(), new Item.Properties()))));
        }
        return map;
    }

    private static void registerSignPostItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("sign_post");
            SignPostItem item = new SignPostItem(ModRegistry.SIGN_POST_WALL.get(), new Item.Properties().m_41487_(16), wood);
            wood.addChild("supplementaries:sign_post", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.SIGN_POST_ITEMS.put(wood, item);
        }
    }

    public static Map<DyeColor, Supplier<Block>> registerAwnings(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<Block> defAwning = RegUtils.regBlock(baseName, () -> new AwningBlock(null, BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283761_).m_60978_(1.0f).m_280606_().m_60955_().m_60918_(SoundType.f_56745_)));
        map.put(null, defAwning);
        RegUtils.regItem(baseName, () -> new BlockItem((Block)defAwning.get(), new Item.Properties()));
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.m_41065_();
            RegSupplier<Block> block = RegUtils.regBlock(name, () -> new AwningBlock(color, BlockBehaviour.Properties.m_284310_().m_278183_().m_280606_().m_284180_(color.m_284406_()).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56745_)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return map;
    }
}

