/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class LootTablesInjects {
    private static final List<BiConsumer<Consumer<ResourceLocation>, TableType>> LOOT_INJECTS = new ArrayList<BiConsumer<Consumer<ResourceLocation>, TableType>>();
    private static final boolean RS = CompatHandler.REPURPOSED_STRUCTURES;
    private static final Pattern RS_SHIPWRECK = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/treasure_chest");
    private static final Pattern RS_SHIPWRECK_STORAGE = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/supply_chest");
    private static final Pattern RS_TEMPLE = Pattern.compile("repurposed_structures:chests/temple/\\w*_chest");
    private static final Pattern RS_TEMPLE_DISPENSER = Pattern.compile("repurposed_structures:chests/temple/\\w*_dispenser");

    public static void init() {
        RegHelper.addLootTableInjects(LootTablesInjects::injectLootPools);
    }

    private static ResourceLocation injectLootPools(RegHelper.LootInjectEvent event) {
        String location;
        TableType type;
        String nameSpace = event.getTable().m_135827_();
        if ((nameSpace.equals("minecraft") || nameSpace.equals("repurposed_structures")) && (type = LootTablesInjects.getType(location = event.getTable().toString())) != TableType.OTHER) {
            LOOT_INJECTS.forEach(i -> i.accept(arg_0 -> ((RegHelper.LootInjectEvent)event).addTableReference(arg_0), type));
        }
        return null;
    }

    public static void setup() {
        if (CommonConfigs.Building.GLOBE_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectGlobe);
        }
        if (CommonConfigs.Tools.QUIVER_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectQuiver);
        }
        if (CommonConfigs.Functional.ROPE_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectRope);
        }
        if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectFlax);
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectBlueBomb);
        }
        if (CommonConfigs.Tools.BOMB_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectBomb);
        }
        if (CommonConfigs.stasisEnabled()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectStasis);
        }
        if (CommonConfigs.Functional.BAMBOO_SPIKES_ENABLED.get().booleanValue() && CommonConfigs.Functional.TIPPED_SPIKES_ENABLED.get().booleanValue()) {
            LOOT_INJECTS.add(LootTablesInjects::tryInjectSpikes);
        }
    }

    private static TableType getType(String name) {
        if (LootTablesInjects.isShipwreck(name)) {
            return TableType.SHIPWRECK_TREASURE;
        }
        if (LootTablesInjects.isShipwreckStorage(name)) {
            return TableType.SHIPWRECK_STORAGE;
        }
        if (LootTablesInjects.isMineshaft(name)) {
            return TableType.MINESHAFT;
        }
        if (LootTablesInjects.isDungeon(name)) {
            return TableType.DUNGEON;
        }
        if (LootTablesInjects.isTemple(name)) {
            return TableType.TEMPLE;
        }
        if (LootTablesInjects.isTempleDispenser(name)) {
            return TableType.TEMPLE_DISPENSER;
        }
        if (LootTablesInjects.isOutpost(name)) {
            return TableType.PILLAGER;
        }
        if (LootTablesInjects.isStronghold(name)) {
            return TableType.STRONGHOLD;
        }
        if (LootTablesInjects.isFortress(name)) {
            return TableType.FORTRESS;
        }
        if (LootTablesInjects.isEndCity(name)) {
            return TableType.END_CITY;
        }
        if (LootTablesInjects.isMansion(name)) {
            return TableType.MANSION;
        }
        if (LootTablesInjects.isFishTreasure(name)) {
            return TableType.FISHING_TREASURE;
        }
        return TableType.OTHER;
    }

    private static boolean isFishTreasure(String name) {
        return name.equals(BuiltInLootTables.f_78722_.toString());
    }

    private static boolean isMansion(String name) {
        return name.equals(BuiltInLootTables.f_78689_.toString()) || RS && name.contains("repurposed_structures:chests/mansion");
    }

    private static boolean isShipwreck(String s) {
        return s.equals(BuiltInLootTables.f_78695_.toString()) || RS && RS_SHIPWRECK.matcher(s).matches();
    }

    private static boolean isShipwreckStorage(String s) {
        return s.equals(BuiltInLootTables.f_78694_.toString()) || RS && RS_SHIPWRECK_STORAGE.matcher(s).matches();
    }

    private static boolean isMineshaft(String s) {
        return s.equals(BuiltInLootTables.f_78759_.toString()) || RS && s.contains("repurposed_structures:chests/mineshaft");
    }

    private static boolean isOutpost(String s) {
        return s.equals(BuiltInLootTables.f_78696_.toString()) || RS && s.contains("repurposed_structures:chests/outpost");
    }

    private static boolean isDungeon(String s) {
        return s.equals(BuiltInLootTables.f_78742_.toString()) || RS && s.contains("repurposed_structures:chests/dungeon");
    }

    private static boolean isTemple(String s) {
        return s.equals(BuiltInLootTables.f_78686_.toString()) || RS && RS_TEMPLE.matcher(s).matches();
    }

    private static boolean isTempleDispenser(String s) {
        return s.equals(BuiltInLootTables.f_78686_.toString()) || RS && RS_TEMPLE_DISPENSER.matcher(s).matches();
    }

    private static boolean isStronghold(String s) {
        return s.equals(BuiltInLootTables.f_78762_.toString()) || RS && s.contains("repurposed_structures:chests/stronghold/nether_storage_room");
    }

    private static boolean isFortress(String s) {
        return s.equals(BuiltInLootTables.f_78760_.toString()) || RS && s.contains("repurposed_structures:chests/fortress");
    }

    private static boolean isEndCity(String s) {
        return s.equals(BuiltInLootTables.f_78741_.toString());
    }

    private static void injectPool(Consumer<ResourceLocation> consumer, TableType type, String name) {
        String id = type.toString().toLowerCase(Locale.ROOT) + "_" + name;
        consumer.accept(Supplementaries.res("inject/" + id));
    }

    private static void tryInjectGlobe(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.SHIPWRECK_TREASURE) {
            LootTablesInjects.injectPool(e, type, "globe");
        }
    }

    private static void tryInjectQuiver(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.DUNGEON || type == TableType.MANSION) {
            LootTablesInjects.injectPool(e, type, "quiver");
        }
    }

    private static void tryInjectRope(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.MINESHAFT) {
            LootTablesInjects.injectPool(e, type, "rope");
        }
    }

    private static void tryInjectFlax(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.MINESHAFT || type == TableType.DUNGEON || type == TableType.SHIPWRECK_STORAGE || type == TableType.PILLAGER) {
            LootTablesInjects.injectPool(e, type, "flax");
        }
    }

    private static void tryInjectBlueBomb(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS || type == TableType.DUNGEON) {
            LootTablesInjects.injectPool(e, type, "blue_bomb");
        }
    }

    private static void tryInjectBomb(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS) {
            LootTablesInjects.injectPool(e, type, "bomb");
        }
    }

    private static void tryInjectSpikes(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.TEMPLE) {
            LootTablesInjects.injectPool(e, type, "spikes");
        }
    }

    private static void tryInjectStasis(Consumer<ResourceLocation> e, TableType type) {
        if (type == TableType.END_CITY) {
            LootTablesInjects.injectPool(e, type, "stasis");
        }
    }

    private static enum TableType {
        OTHER,
        MINESHAFT,
        SHIPWRECK_TREASURE,
        PILLAGER,
        DUNGEON,
        PYRAMID,
        STRONGHOLD,
        TEMPLE,
        TEMPLE_DISPENSER,
        IGLOO,
        MANSION,
        FORTRESS,
        BASTION,
        RUIN,
        SHIPWRECK_STORAGE,
        END_CITY,
        FISHING_TREASURE;

    }
}

