/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.forge.QuiverItemImpl;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuiverItem
extends SelectableContainerItem<Data>
implements DyeableLeatherItem {
    public QuiverItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public Data getData(ItemStack stack) {
        return QuiverItem.getQuiverData(stack);
    }

    @Override
    public int getMaxSlots() {
        return CommonConfigs.Tools.QUIVER_SLOTS.get();
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getQuiverData(ItemStack stack) {
        return QuiverItemImpl.getQuiverData(stack);
    }

    @NotNull
    public static SlotReference findActiveQuiverSlot(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SlotReference curioQuiver = CompatHandler.getQuiverFromModsSlots(player);
            if (!curioQuiver.isEmpty()) {
                return curioQuiver;
            }
            if (CommonConfigs.Tools.QUIVER_CURIO_ONLY.get().booleanValue()) {
                return SlotReference.EMPTY;
            }
        } else if (entity instanceof IQuiverEntity) {
            IQuiverEntity e = (IQuiverEntity)entity;
            return SlotReference.quiver(e);
        }
        return SuppPlatformStuff.getFirstInInventory(entity, i -> i.m_41720_() instanceof QuiverItem);
    }

    public static ItemStack findActiveQuiver(LivingEntity entity) {
        return QuiverItem.findActiveQuiverSlot(entity).get(entity);
    }

    public static boolean canAcceptItem(ItemStack toInsert) {
        return toInsert.m_41720_() instanceof ArrowItem && !toInsert.m_204117_(ModTags.QUIVER_BLACKLIST);
    }

    public static interface Data
    extends SelectableContainerItem.AbstractData {
        @Override
        default public boolean canAcceptItem(ItemStack toInsert) {
            return QuiverItem.canAcceptItem(toInsert);
        }

        @Override
        default public ItemStack getSelected() {
            return this.getSelected(null);
        }

        default public ItemStack getSelected(@Nullable Predicate<ItemStack> supporterArrows) {
            List<ItemStack> content = this.getContentView();
            int selected = this.getSelectedSlot();
            if (supporterArrows == null) {
                return content.get(selected);
            }
            int size = content.size();
            for (int i = 0; i < size; ++i) {
                ItemStack s = content.get((i + selected) % size);
                if (!supporterArrows.test(s)) continue;
                return s;
            }
            return ItemStack.f_41583_;
        }
    }
}

