/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.PresentContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PresentBlockTile
extends AbstractPresentBlockTile {
    public static final String PUBLIC_KEY = "@e";
    private String recipient = "";
    private String sender = "";
    private String description = "";

    public PresentBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.PRESENT_TILE.get(), pos, state);
    }

    @Override
    public boolean canHoldItems() {
        return this.isPacked();
    }

    public boolean isPacked() {
        return (Boolean)this.m_58900_().m_61143_((Property)PresentBlock.PACKED);
    }

    public String getSender() {
        return this.sender;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecipient() {
        if (this.recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return "";
        }
        return this.recipient;
    }

    public void setSender(String sender) {
        this.sender = sender.trim();
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient.trim();
    }

    public void setPublic() {
        this.setRecipient(PUBLIC_KEY);
    }

    public void updateState(boolean shouldPack, String newRecipient, String sender, String description, Player playerWhoChanged) {
        if (shouldPack) {
            if (newRecipient.isEmpty()) {
                newRecipient = PUBLIC_KEY;
            }
            this.recipient = newRecipient;
            this.sender = sender;
            this.description = description;
        } else {
            this.recipient = "";
            this.sender = "";
            this.description = "";
        }
        if (!this.f_58857_.f_46443_ && this.isPacked() != shouldPack) {
            if (shouldPack) {
                this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.PRESENT_PACK.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.95f);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.PRESENT_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.2f);
            }
            this.f_58857_.m_142346_((Entity)playerWhoChanged, GameEvent.f_157792_, this.f_58858_);
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(shouldPack)), 3);
        }
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return super.m_7013_(index, stack) && !this.isPacked();
    }

    public boolean m_7525_(Player player) {
        if (!super.m_7525_(player)) {
            return false;
        }
        if (!this.isUnused()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        return this.recipient.isEmpty() || this.recipient.equalsIgnoreCase(PUBLIC_KEY) || this.recipient.equalsIgnoreCase(player.m_7755_().getString()) || this.sender.equalsIgnoreCase(player.m_7755_().getString());
    }

    @Override
    public InteractionResult interact(Level level, BlockPos pos, BlockState state, Player player) {
        if (this.isUnused()) {
            if (this.m_7525_(player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlatHelper.openCustomMenu((ServerPlayer)serverPlayer, (MenuProvider)this, (BlockPos)pos);
                    PiglinAi.m_34873_((Player)player, (boolean)true);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            player.m_5661_((Component)Component.m_237110_((String)"message.supplementaries.present.info", (Object[])new Object[]{this.recipient}), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"gui.supplementaries.present");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.recipient = "";
        this.sender = "";
        this.description = "";
        if (tag.m_128441_("Recipient")) {
            this.recipient = tag.m_128461_("Recipient");
        }
        if (tag.m_128441_("Sender")) {
            this.sender = tag.m_128461_("Sender");
        }
        if (tag.m_128441_("Description")) {
            this.description = tag.m_128461_("Description");
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.recipient.isEmpty()) {
            tag.m_128359_("Recipient", this.recipient);
        }
        if (!this.sender.isEmpty()) {
            tag.m_128359_("Sender", this.sender);
        }
        if (!this.description.isEmpty()) {
            tag.m_128359_("Description", this.description);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inv) {
        if (inv.f_35978_.m_5833_()) {
            return null;
        }
        return new PresentContainerMenu(id, inv, this);
    }

    @Nullable
    public MutableComponent getSenderMessage() {
        return PresentBlockTile.getSenderMessage(this.sender);
    }

    @Nullable
    public static MutableComponent getSenderMessage(String sender) {
        if (sender.isEmpty()) {
            return null;
        }
        return Component.m_237110_((String)"message.supplementaries.present.from", (Object[])new Object[]{sender});
    }

    @Nullable
    public MutableComponent getRecipientMessage() {
        return PresentBlockTile.getRecipientMessage(this.recipient);
    }

    @Nullable
    public static MutableComponent getRecipientMessage(String recipient) {
        if (recipient.isEmpty()) {
            return null;
        }
        if (recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return Component.m_237115_((String)"message.supplementaries.present.public");
        }
        return Component.m_237110_((String)"message.supplementaries.present.to", (Object[])new Object[]{recipient});
    }
}

