/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.helper.Helper;

public record CMessageLevelUp(int earnedLevel) {
    static CMessageLevelUp fromBytes(FriendlyByteBuf buf) {
        return new CMessageLevelUp(buf.readByte() & 0xFF);
    }

    static void toBytes(CMessageLevelUp msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.earnedLevel);
    }

    public static class Handler {
        static void handle(final CMessageLevelUp msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ClientEventHandler.showEarnedLevel(msg.earnedLevel);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

