/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfMagicImpregnation
extends ItemBook {
    public ItemBookOfMagicImpregnation() {
        super("book_of_magic_impregnation", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfMagicImpregnation.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        int consumed;
        ItemStack mainhand;
        if (stack.m_41720_() != this || (mainhand = player.m_21205_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
        }
        if (mainhand.m_150930_(Items.f_42412_)) {
            consumed = soulStrength;
            player.m_8061_(EquipmentSlot.MAINHAND, soulStrength == 1 ? EffectHelper.createRandomArrows(mainhand.m_41613_()) : EffectHelper.createCursedArrows(mainhand.m_41613_()));
            ModTriggers.CREATE_IMBUED_ARROW.trigger(player);
        } else {
            Map<Enchantment, Integer> enchantments = this.getDeserializedEnchantments(mainhand);
            if (enchantments.isEmpty()) {
                int enchantability = mainhand.getEnchantmentValue();
                if (!mainhand.m_41792_() || enchantability == 0) {
                    return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
                }
                consumed = soulStrength;
                enchantments = this.getRandomEnchantments(enchantability + Helper.RANDOM.nextInt(soulStrength * 30), mainhand, soulStrength > 1);
                if (mainhand.m_150930_(Items.f_42517_)) {
                    mainhand = new ItemStack((ItemLike)Items.f_42690_);
                    player.m_8061_(EquipmentSlot.MAINHAND, mainhand);
                }
            } else {
                List<Map.Entry> upgradables = enchantments.entrySet().stream().filter(e -> Helper.getMaxLevel((Enchantment)e.getKey()) > (Integer)e.getValue()).toList();
                if (upgradables.isEmpty()) {
                    return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_MAX.getText(new Object[0]));
                }
                if (soulStrength == 1 || upgradables.size() == 1) {
                    Map.Entry entry2 = upgradables.get(Helper.RANDOM.nextInt(upgradables.size()));
                    consumed = 1;
                    enchantments.put((Enchantment)entry2.getKey(), Math.min((Integer)entry2.getValue() + 3, ((Enchantment)entry2.getKey()).m_6586_()));
                } else {
                    consumed = 2;
                    enchantments.entrySet().stream().filter(e -> Helper.getMaxLevel((Enchantment)e.getKey()) > (Integer)e.getValue()).forEach(entry -> entry.setValue(Math.min((Integer)entry.getValue() + 3, ((Enchantment)entry.getKey()).m_6586_())));
                }
            }
            EnchantmentHelper.m_44865_(enchantments, (ItemStack)mainhand);
        }
        stack.m_41774_(1);
        ModTriggers.USE_MAGIC_IMPREGNATION.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_SUCCESS.getText(new Object[0]), consumed);
    }

    private Map<Enchantment, Integer> getRandomEnchantments(int roll, ItemStack stack, boolean hasStrongSoul) {
        ArrayList<EnchantmentInstance> availableEnchantments = new ArrayList<EnchantmentInstance>();
        boolean isSoulbound = NBTStackHelper.getBoolean(stack, "soulbound");
        block0: for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            int maxLevel;
            if (isSoulbound && enchantment == ModEnchantments.soulbound || enchantment.m_6589_()) continue;
            for (int i = maxLevel = Helper.getMaxLevel(enchantment); i >= enchantment.m_44702_(); --i) {
                if (roll < enchantment.m_6183_(i) || i != maxLevel && roll > enchantment.m_6175_(i)) continue;
                availableEnchantments.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        HashMap<Enchantment, Integer> res = new HashMap<Enchantment, Integer>();
        if (!availableEnchantments.isEmpty()) {
            int max = hasStrongSoul ? 6 : 3;
            for (int i = 0; i < max && !availableEnchantments.isEmpty(); ++i) {
                WeightedRandom.m_216822_((RandomSource)Helper.RANDOM_SOURCE, availableEnchantments).ifPresent(enchantmentInstance -> {
                    res.put(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_);
                    availableEnchantments.removeIf(e -> !e.f_44947_.m_44695_(enchantmentInstance.f_44947_));
                });
            }
        }
        return res;
    }
}

