/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupService {
    private static final Logger LOGGER = LogManager.getLogger((String)"Tombstone Backup");
    private static ExecutorService executorService;

    public static ExecutorService get() {
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor(new BackupThreadFactory());
        }
        return executorService;
    }

    public static void stop() {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
        }
        executorService = null;
    }

    private static class BackupThreadFactory
    implements ThreadFactory {
        private static final String NAME_PREFIX = "Tombstone Backup Thread";
        private final ThreadGroup group = Optional.ofNullable(System.getSecurityManager()).map(SecurityManager::getThreadGroup).orElse(Thread.currentThread().getThreadGroup());

        private BackupThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, NAME_PREFIX, 0L);
            thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            LOGGER.error("Caught previously unhandled exception :");
            LOGGER.error(thread.getName(), throwable);
        }
    }
}

