/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class FollowOwnerGoal
extends Goal {
    public final Mob mob;
    private Player owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;
    private final double teleportDistance;

    public FollowOwnerGoal(Mob mob, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.mob = mob;
        this.level = mob.m_9236_();
        this.speedModifier = speedModifier;
        this.navigation = mob.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.teleportDistance = (double)(this.startDistance * this.startDistance) * 2.0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_21523_()) {
            return false;
        }
        this.owner = this.getOwner().orElse(null);
        return this.owner != null && this.owner.m_9236_().m_46472_().equals((Object)this.mob.m_9236_().m_46472_()) && !this.owner.m_5833_() && this.mob.m_20280_((Entity)this.owner) >= (double)(this.startDistance * this.startDistance);
    }

    public boolean m_8045_() {
        return !this.mob.m_21523_() && !this.navigation.m_26571_() && this.mob.m_20280_((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.mob.m_21523_() && !this.mob.m_20159_()) {
                if (this.requireTeleport()) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            if (!this.maybeTeleportTo(blockpos.m_123341_() + this.randomIntInclusive(-3, 3), blockpos.m_123342_() + this.randomIntInclusive(-1, 1), blockpos.m_123343_() + this.randomIntInclusive(-3, 3))) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.mob.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pos.m_7495_());
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.mob.m_20183_());
        return this.level.m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.mob.m_217043_().m_188503_(max - min + 1) + min;
    }

    protected abstract Optional<Player> getOwner();

    protected boolean requireTeleport() {
        return this.mob.m_20280_((Entity)this.owner) >= this.teleportDistance * Optional.ofNullable(this.mob.m_5448_()).filter(LivingEntity::m_6084_).map(e -> 2.0).orElse(1.0);
    }
}

