/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.registry.ModBlocks;

public abstract class BlockGraveBase
extends HorizontalDirectionalBlock
implements BucketPickup,
LiquidBlockContainer,
EntityBlock {
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.m_61465_((String)"is_engraved");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.m_61631_((String)"model_texture", (int)0, (int)(BlockGraveMarble.MarbleType.values().length - 1));
    protected final GraveModel graveModel;

    public BlockGraveBase(BlockBehaviour.Properties builder, GraveModel graveModel) {
        super(builder.m_278166_(PushReaction.IGNORE).m_60991_((state, level, pos) -> true).m_60953_(state -> 5));
        this.graveModel = graveModel;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(0))).m_61124_((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public String m_7705_() {
        return "tombstone.grave." + this.graveModel.m_7912_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)MODEL_TEXTURE, (Comparable)Integer.valueOf(ItemBlockGrave.getModelTexture(context.m_43722_())))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_()).m_60734_() != this && context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_))).m_61124_((Property)IS_ENGRAVED, (Comparable)Boolean.valueOf(EngravableHelper.isEngraved(context.m_43722_())));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, MODEL_TEXTURE, IS_ENGRAVED, WATERLOGGED});
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter blockGetter, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter blockGetter, BlockPos pos, Explosion explosion) {
        return false;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_7500_()) {
            level.m_5898_(player, 2001, pos, BlockGraveBase.m_49956_((BlockState)state));
            if (!level.m_5776_()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.m_5776_() && (ModBlocks.isPlayerGrave(state.m_60734_()) && !ModBlocks.isPlayerGrave(newState.m_60734_()) || ModBlocks.isDecorativeGrave(state.m_60734_()) && !ModBlocks.isDecorativeGrave(newState.m_60734_()))) {
            if (DeathHandler.INSTANCE.canRemovePlayerGrave(level, pos)) {
                this.onDrop(level, pos, state);
            } else {
                Optional.ofNullable(level.m_7702_(pos)).ifPresent(grave -> {
                    CompoundTag oldNbt = grave.m_187480_();
                    CallbackHandler.addFastCallback(() -> {
                        level.m_46597_(pos, state);
                        Optional.ofNullable(level.m_7702_(pos)).ifPresent(newGrave -> {
                            newGrave.m_142466_(oldNbt);
                            newGrave.m_6596_();
                            level.m_7260_(pos, newState, state, 3);
                        });
                    });
                });
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected abstract void onDrop(Level var1, BlockPos var2, BlockState var3);

    public BlockState m_7417_(BlockState olState, Direction facing, BlockState newState, LevelAccessor levelAccessor, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)olState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(oldPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(olState, facing, newState, levelAccessor, oldPos, newPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            if (!levelAccessor.m_5776_()) {
                levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public boolean m_7420_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return this.graveModel.getShape((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
    }

    public GraveModel getGraveType() {
        return this.graveModel;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> toCompare, BlockEntityType<E> entityType, BlockEntityTicker<? super E> ticker) {
        return entityType == toCompare ? ticker : null;
    }
}

