/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class LeechBlockBonus
extends GemBonus {
    public static Codec<LeechBlockBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, LeechBlockBonus::new));
    protected final Map<LootRarity, Data> values;

    public LeechBlockBonus(Map<LootRarity, Data> values) {
        super(Apotheosis.loc("leech_block"), new GemClass("shield", (Set<LootCategory>)ImmutableSet.of((Object)LootCategory.SHIELD)));
        this.values = values;
    }

    @Override
    public float onShieldBlock(ItemStack gem, LootRarity rarity, LivingEntity entity, DamageSource source, float amount) {
        Data d = this.values.get(rarity);
        if (amount <= 2.0f || Affix.isOnCooldown(this.getCooldownId(gem), d.cooldown, entity)) {
            return amount;
        }
        entity.m_5634_(amount * d.healFactor);
        Affix.startCooldown(this.getCooldownId(gem), entity);
        return amount;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(ItemStack gem, LootRarity rarity) {
        Data d = this.values.get(rarity);
        MutableComponent cooldown = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)d.cooldown)});
        return Component.m_237110_((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(d.healFactor * 100.0f), cooldown}).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public LeechBlockBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    record Data(float healFactor, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("heal_factor").forGetter(Data::healFactor), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }
}

