/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GemItem
extends Item
implements ITabFiller {
    public static final String HAS_REFRESHED = "has_refreshed";
    public static final String UUID_ARRAY = "uuids";
    public static final String GEM = "gem";

    public GemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            tooltip.add((Component)Component.m_237113_((String)"Errored gem with no bonus!").m_130940_(ChatFormatting.GRAY));
            return;
        }
        ((Gem)inst.gem().get()).addInformation(pStack, (LootRarity)inst.rarity().get(), tooltip::add);
    }

    public Component m_7626_(ItemStack pStack) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            return super.m_7626_(pStack);
        }
        MutableComponent comp = Component.m_237115_((String)this.m_5671_(pStack));
        comp = Component.m_237110_((String)("item.apotheosis.gem." + inst.rarity().getId()), (Object[])new Object[]{comp});
        return comp.m_130948_(Style.f_131099_.m_131148_(((LootRarity)inst.rarity().get()).getColor()));
    }

    public String m_5671_(ItemStack pStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(pStack);
        if (!gem.isBound()) {
            return super.m_5524_();
        }
        return super.m_5671_(pStack) + "." + gem.getId();
    }

    public boolean m_5812_(ItemStack pStack) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            return super.m_5812_(pStack);
        }
        return inst.isMaxRarity();
    }

    public boolean m_41386_(DamageSource src) {
        return super.m_41386_(src) && !src.m_276093_(DamageTypes.f_268526_);
    }

    public void fillItemCategory(CreativeModeTab group, CreativeModeTab.Output out) {
        GemRegistry.INSTANCE.getValues().stream().sorted(Comparator.comparing(Gem::getId)).forEach(gem -> RarityRegistry.INSTANCE.getOrderedRarities().stream().map(DynamicHolder::get).forEach(rarity -> {
            if (gem.clamp((LootRarity)rarity) == rarity) {
                ItemStack stack = new ItemStack((ItemLike)this);
                GemItem.setGem(stack, gem);
                AffixHelper.setRarity(stack, rarity);
                out.m_246342_(stack);
            }
        }));
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        GemInstance inst = GemInstance.unsocketed(stack);
        if (inst.isValidUnsocketed()) {
            return inst.gem().getId().m_135827_();
        }
        return super.getCreatorModId(stack);
    }

    public static List<UUID> getUUIDs(ItemStack gemStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(gemStack);
        if (!gem.isBound()) {
            return Collections.emptyList();
        }
        return GemItem.getOrCreateUUIDs(gemStack.m_41784_(), ((Gem)gem.get()).getNumberOfUUIDs());
    }

    public static List<UUID> getOrCreateUUIDs(CompoundTag tag, int numUUIDs) {
        if (numUUIDs == 0) {
            return Collections.emptyList();
        }
        if (tag.m_128441_(UUID_ARRAY)) {
            ListTag list = tag.m_128437_(UUID_ARRAY, 11);
            ArrayList<UUID> ret = new ArrayList<UUID>(list.size());
            for (Tag t : list) {
                ret.add(NbtUtils.m_129233_((Tag)t));
            }
            if (ret.size() < numUUIDs) {
                return GemItem.generateAndSave(ret, numUUIDs, tag);
            }
            return ret;
        }
        return GemItem.generateAndSave(new ArrayList<UUID>(numUUIDs), numUUIDs, tag);
    }

    private static List<UUID> generateAndSave(List<UUID> base, int amount, CompoundTag tag) {
        int needed = amount - base.size();
        for (int i = 0; i < needed; ++i) {
            base.add(UUID.randomUUID());
        }
        ListTag list = new ListTag();
        for (UUID id : base) {
            list.add((Object)NbtUtils.m_129226_((UUID)id));
        }
        tag.m_128365_(UUID_ARRAY, (Tag)list);
        return base;
    }

    public static void setGem(ItemStack gemStack, Gem gem) {
        gemStack.m_41784_().m_128359_(GEM, gem.getId().toString());
    }

    public static DynamicHolder<Gem> getGem(ItemStack gem) {
        if (gem.m_41720_() != Adventure.Items.GEM.get() || !gem.m_41782_()) {
            return GemRegistry.INSTANCE.emptyHolder();
        }
        try {
            CompoundTag tag = gem.m_41783_();
            return GemRegistry.INSTANCE.holder(new ResourceLocation(tag.m_128461_(GEM)));
        }
        catch (ResourceLocationException ex) {
            return GemRegistry.INSTANCE.emptyHolder();
        }
    }
}

