/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket;

import com.google.common.collect.ImmutableList;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.event.GetItemSocketsEvent;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SocketHelper {
    public static final ResourceLocation GEMS_CACHED_OBJECT = Apotheosis.loc("gems");
    public static final String AFFIX_DATA = "affix_data";
    public static final String GEMS = "gems";
    public static final String SOCKETS = "sockets";

    public static int getSockets(ItemStack stack) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        int sockets = afxData != null ? afxData.m_128451_(SOCKETS) : 0;
        GetItemSocketsEvent event = new GetItemSocketsEvent(stack, sockets);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getSockets();
    }

    public static void setSockets(ItemStack stack, int sockets) {
        stack.m_41698_(AFFIX_DATA).m_128405_(SOCKETS, sockets);
    }

    public static SocketedGems getGems(ItemStack stack) {
        return (SocketedGems)CachedObject.CachedObjectSource.getOrCreate((ItemStack)stack, (ResourceLocation)GEMS_CACHED_OBJECT, SocketHelper::getGemsImpl, SocketHelper::hashSockets);
    }

    private static int hashSockets(ItemStack stack) {
        return Objects.hash(stack.m_41737_(AFFIX_DATA), SocketHelper.getSockets(stack));
    }

    private static SocketedGems getGemsImpl(ItemStack stack) {
        int size = SocketHelper.getSockets(stack);
        if (size <= 0 || stack.m_41619_()) {
            return SocketedGems.EMPTY;
        }
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return SocketedGems.EMPTY;
        }
        NonNullList gems = NonNullList.m_122780_((int)size, (Object)GemInstance.EMPTY);
        int i = 0;
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(GEMS)) {
            ListTag gemData = afxData.m_128437_(GEMS, 10);
            for (Tag tag : gemData) {
                ItemStack gemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                gemStack.m_41764_(1);
                GemInstance inst = GemInstance.socketed(stack, gemStack);
                if (inst.isValid()) {
                    gems.set(i++, inst);
                }
                if (i < size) continue;
                break;
            }
        }
        return new SocketedGems((ImmutableList<GemInstance>)ImmutableList.copyOf((Collection)gems));
    }

    public static void setGems(ItemStack stack, SocketedGems gems) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        ListTag gemData = new ListTag();
        for (GemInstance inst : gems) {
            gemData.add((Object)inst.gemStack().m_41739_(new CompoundTag()));
        }
        afxData.m_128365_(GEMS, (Tag)gemData);
    }

    public static boolean hasEmptySockets(ItemStack stack) {
        return SocketHelper.getGems(stack).gems().stream().anyMatch(g -> !g.isValid());
    }

    public static int getFirstEmptySocket(ItemStack stack) {
        SocketedGems gems = SocketHelper.getGems(stack);
        for (int socket = 0; socket < gems.size(); ++socket) {
            if (gems.get(socket).isValid()) continue;
            return socket;
        }
        return 0;
    }

    private static List<ItemStack> getGems(AbstractArrow arrow) {
        int sockets;
        CompoundTag afxData = arrow.getPersistentData().m_128469_(AFFIX_DATA);
        int n = sockets = afxData != null ? afxData.m_128451_(SOCKETS) : 0;
        if (sockets <= 0) {
            return Collections.emptyList();
        }
        NonNullList gems = NonNullList.m_122780_((int)sockets, (Object)ItemStack.f_41583_);
        int i = 0;
        if (afxData != null && afxData.m_128441_(GEMS)) {
            ListTag gemData = afxData.m_128437_(GEMS, 10);
            for (Tag tag : gemData) {
                ItemStack gemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                gemStack.m_41764_(1);
                if (GemInstance.unsocketed(gemStack).isValidUnsocketed()) {
                    gems.set(i++, gemStack);
                }
                if (i < sockets) continue;
                break;
            }
        }
        return gems;
    }

    public static Stream<GemInstance> getGemInstances(AbstractArrow arrow) {
        LootCategory cat = AffixHelper.getShooterCategory((Entity)arrow);
        if (cat == null) {
            return Stream.empty();
        }
        return SocketHelper.getGems(arrow).stream().map(gemStack -> GemInstance.socketed(cat, gemStack)).filter(GemInstance::isValid);
    }
}

