/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.reforging;

import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record ReforgingRecipe(ResourceLocation id, DynamicHolder<LootRarity> rarity, int matCost, int sigilCost, int levelCost) implements Recipe<Container>
{
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Apoth.RecipeTypes.REFORGING;
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess regs) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    @Deprecated
    public ItemStack m_5874_(Container pContainer, RegistryAccess regs) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<ReforgingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ReforgingRecipe fromJson(ResourceLocation id, JsonObject obj) {
            DynamicHolder<LootRarity> rarity = RarityRegistry.byLegacyId(GsonHelper.m_13906_((JsonObject)obj, (String)"rarity"));
            int matCost = GsonHelper.m_13927_((JsonObject)obj, (String)"material_cost");
            int sigilCost = GsonHelper.m_13927_((JsonObject)obj, (String)"sigil_cost");
            int levelCost = GsonHelper.m_13927_((JsonObject)obj, (String)"level_cost");
            return new ReforgingRecipe(id, rarity, matCost, sigilCost, levelCost);
        }

        public void toNetwork(FriendlyByteBuf buf, ReforgingRecipe recipe) {
            buf.m_130085_(recipe.rarity.getId());
            buf.writeByte(recipe.matCost);
            buf.writeByte(recipe.sigilCost);
            buf.writeByte(recipe.levelCost);
        }

        public ReforgingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(buf.m_130281_());
            return new ReforgingRecipe(id, (DynamicHolder<LootRarity>)rarity, buf.readByte(), buf.readByte(), buf.readByte());
        }
    }
}

