/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.CleavingAffix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class ThunderstruckAffix
extends Affix {
    public static final Codec<ThunderstruckAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ThunderstruckAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public ThunderstruckAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        return Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{ThunderstruckAffix.fmt(this.getTrueLevel(rarity, level))});
    }

    @Override
    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        MutableComponent comp = this.getDescription(stack, rarity, level);
        MutableComponent minComp = Component.m_237113_((String)ThunderstruckAffix.fmt(this.getTrueLevel(rarity, 0.0f)));
        MutableComponent maxComp = Component.m_237113_((String)ThunderstruckAffix.fmt(this.getTrueLevel(rarity, 1.0f)));
        return comp.m_7220_((Component)ThunderstruckAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isLightWeapon() && this.values.containsKey(rarity);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if (user.m_9236_().f_46443_) {
            return;
        }
        if ((double)Apotheosis.getLocalAtkStrength((Entity)user) >= 0.98) {
            List nearby = target.m_9236_().m_6249_(target, new AABB(target.m_20183_()).m_82400_(6.0), CleavingAffix.cleavePredicate((Entity)user, target));
            for (Entity e : nearby) {
                e.m_6469_(user.m_269291_().m_269333_(user), this.getTrueLevel(rarity, level));
            }
        }
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

