/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class TelepathicAffix
extends Affix {
    public static final Codec<TelepathicAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.CODEC.fieldOf("min_rarity").forGetter(a -> a.minRarity)).apply((Applicative)inst, TelepathicAffix::new));
    public static Vec3 blockDropTargetPos = null;
    protected LootRarity minRarity;

    public TelepathicAffix(LootRarity minRarity) {
        super(AffixType.ABILITY);
        this.minRarity = minRarity;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return (cat.isRanged() || cat.isLightWeapon() || cat.isBreaker()) && rarity.isAtLeast(this.minRarity);
    }

    @Override
    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        LootCategory cat = LootCategory.forItem(stack);
        String type = cat.isRanged() || cat.isWeapon() ? "weapon" : "tool";
        return Component.m_237115_((String)("affix." + this.getId() + ".desc." + type));
    }

    @Override
    public boolean enablesTelepathy() {
        return true;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static void drops(LivingDropsEvent e) {
        AbstractArrow arrow;
        DamageSource src = e.getSource();
        boolean canTeleport = false;
        Vec3 targetPos = null;
        Entity entity = src.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_19749_() != null) {
            canTeleport = AffixHelper.streamAffixes(arrow).anyMatch(AffixInstance::enablesTelepathy);
            targetPos = arrow.m_19749_().m_20182_();
        } else {
            entity = src.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack weapon = living.m_21205_();
                canTeleport = AffixHelper.streamAffixes(weapon).anyMatch(AffixInstance::enablesTelepathy);
                targetPos = living.m_20182_();
            }
        }
        if (canTeleport) {
            for (ItemEntity item : e.getDrops()) {
                item.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                item.m_32010_(0);
            }
        }
    }
}

