/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.module;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.IndustrialBlockItem;
import com.buuz135.industrial.block.transportstorage.BlackHoleControllerBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleUnitBlock;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBlinkingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBouncingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDetectorUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDroppingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorExtractionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorInsertionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorSplittingUpgrade;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterFluidType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterItemType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterWorldType;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.item.ItemConveyorUpgrade;
import com.buuz135.industrial.item.ItemTransporterType;
import com.buuz135.industrial.module.IModule;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.client.model.ConveyorBlockModel;
import com.buuz135.industrial.proxy.client.model.TransporterBlockModel;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleTransportStorage
implements IModule {
    public static TitaniumTab TAB_TRANSPORT = new TitaniumTab(new ResourceLocation("industrialforegoing", "transport"));
    public static ConveyorUpgradeFactory upgrade_extraction = new ConveyorExtractionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_insertion = new ConveyorInsertionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_detector = new ConveyorDetectorUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_bouncing = new ConveyorBouncingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_dropping = new ConveyorDroppingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_blinking = new ConveyorBlinkingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_splitting = new ConveyorSplittingUpgrade.Factory();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> CONVEYOR = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem("conveyor", () -> new ConveyorBlock(TAB_TRANSPORT), blockRegistryObject -> () -> new IndustrialBlockItem((Block)blockRegistryObject.get(), TAB_TRANSPORT), TAB_TRANSPORT);
    public static HashMap<ResourceLocation, BakedModel> CONVEYOR_UPGRADES_CACHE = new HashMap();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_COMMON = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(Rarity.COMMON.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(Rarity.COMMON), blockRegistryObject -> () -> new BlackHoleUnitBlock.BlackHoleUnitItem((Block)blockRegistryObject.get(), new Item.Properties(), Rarity.COMMON), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_PITY = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.PITY_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.PITY_RARITY), blockRegistryObject -> () -> new BlackHoleUnitBlock.BlackHoleUnitItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.PITY_RARITY), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_SIMPLE = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.SIMPLE_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.SIMPLE_RARITY), blockRegistryObject -> () -> new BlackHoleUnitBlock.BlackHoleUnitItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.SIMPLE_RARITY), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_ADVANCED = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.ADVANCED_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.ADVANCED_RARITY), blockRegistryObject -> () -> new BlackHoleUnitBlock.BlackHoleUnitItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.ADVANCED_RARITY), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_SUPREME = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.SUPREME_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.SUPREME_RARITY), blockRegistryObject -> () -> new BlackHoleUnitBlock.BlackHoleUnitItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.SUPREME_RARITY), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_COMMON = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(Rarity.COMMON.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(Rarity.COMMON), blockRegistryObject -> () -> new BlackHoleTankBlock.BlackHoleTankItem((Block)blockRegistryObject.get(), new Item.Properties(), Rarity.COMMON, TAB_TRANSPORT), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_PITY = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.PITY_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.PITY_RARITY), blockRegistryObject -> () -> new BlackHoleTankBlock.BlackHoleTankItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.PITY_RARITY, TAB_TRANSPORT), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_SIMPLE = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.SIMPLE_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.SIMPLE_RARITY), blockRegistryObject -> () -> new BlackHoleTankBlock.BlackHoleTankItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.SIMPLE_RARITY, TAB_TRANSPORT), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_ADVANCED = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.ADVANCED_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.ADVANCED_RARITY), blockRegistryObject -> () -> new BlackHoleTankBlock.BlackHoleTankItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.ADVANCED_RARITY, TAB_TRANSPORT), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_SUPREME = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem(ModuleCore.SUPREME_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.SUPREME_RARITY), blockRegistryObject -> () -> new BlackHoleTankBlock.BlackHoleTankItem((Block)blockRegistryObject.get(), new Item.Properties(), ModuleCore.SUPREME_RARITY, TAB_TRANSPORT), TAB_TRANSPORT);
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_CONTROLLER = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem("black_hole_controller", () -> new BlackHoleControllerBlock(), blockRegistryObject -> () -> new IndustrialBlockItem((Block)blockRegistryObject.get(), TAB_TRANSPORT), TAB_TRANSPORT);
    public static TransporterTypeFactory ITEM_TRANSPORTER = new TransporterItemType.Factory();
    public static TransporterTypeFactory FLUID_TRANSPORTER = new TransporterFluidType.Factory();
    public static TransporterTypeFactory WORLD_TRANSPORTER = new TransporterWorldType.Factory();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> TRANSPORTER = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTileItem("transporter", () -> new TransporterBlock(), blockRegistryObject -> () -> new TransporterBlock.Item((Block)blockRegistryObject.get(), TAB_TRANSPORT), TAB_TRANSPORT);
    public static HashMap<ResourceLocation, BakedModel> TRANSPORTER_CACHE = new HashMap();

    @Override
    public void generateFeatures(DeferredRegistryHelper registryHelper) {
        registryHelper.registerGeneric(ForgeRegistries.MENU_TYPES.getRegistryKey(), "conveyor", () -> IForgeMenuType.create(ContainerConveyor::new));
        ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> registryHelper.registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), "conveyor_" + conveyorUpgradeFactory.getName() + "_upgrade", () -> new ItemConveyorUpgrade((ConveyorUpgradeFactory)conveyorUpgradeFactory, TAB_TRANSPORT)));
        registryHelper.registerGeneric(ForgeRegistries.MENU_TYPES.getRegistryKey(), "transporter", () -> IForgeMenuType.create(ContainerTransporter::new));
        TransporterTypeFactory.FACTORIES.forEach(transporterTypeFactory -> registryHelper.registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), transporterTypeFactory.getName() + "_transporter_type", () -> new ItemTransporterType((TransporterTypeFactory)transporterTypeFactory, TAB_TRANSPORT)));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::onClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void bakingCompleted(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        ModelBakery modelBakery = event.getModelBakery();
        for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
            for (Direction upgradeFacing : transporterTypeFactory.getValidFacings()) {
                for (TransporterTypeFactory.TransporterAction actions : TransporterTypeFactory.TransporterAction.values()) {
                    try {
                        ResourceLocation resourceLocation = transporterTypeFactory.getModel(upgradeFacing, actions);
                        UnbakedModel unbakedModel = event.getModelBakery().m_119341_(resourceLocation);
                        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.m_119204_(), resourceLocation);
                        BakedModel bakedModel = unbakedModel.m_7611_((ModelBaker)baker, Material::m_119204_, (ModelState)new SimpleModelState(Transformation.m_121093_()), resourceLocation);
                        TRANSPORTER_CACHE.put(resourceLocation, bakedModel);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
            for (Direction upgradeFacing : conveyorUpgradeFactory.getValidFacings()) {
                for (Direction conveyorFacing : ConveyorBlock.FACING.m_6908_()) {
                    try {
                        ResourceLocation resourceLocation = conveyorUpgradeFactory.getModel(upgradeFacing, conveyorFacing);
                        UnbakedModel unbakedModel = event.getModelBakery().m_119341_(resourceLocation);
                        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.m_119204_(), resourceLocation);
                        CONVEYOR_UPGRADES_CACHE.put(resourceLocation, unbakedModel.m_7611_((ModelBaker)baker, Material::m_119204_, (ModelState)new SimpleModelState(Transformation.m_121093_()), resourceLocation));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void modifyBakingResult(ModelEvent.ModifyBakingResult event) {
        for (ResourceLocation resourceLocation : event.getModels().keySet()) {
            if (!resourceLocation.m_135827_().equals("industrialforegoing")) continue;
            if (resourceLocation.m_135815_().contains("transporter") && !resourceLocation.m_135815_().contains("transporters/") && !resourceLocation.m_135815_().contains("type")) {
                event.getModels().put(resourceLocation, new TransporterBlockModel((BakedModel)event.getModels().get(resourceLocation)));
            }
            if (!resourceLocation.m_135815_().contains("conveyor") || resourceLocation.m_135815_().contains("upgrade")) continue;
            event.getModels().put(resourceLocation, new ConveyorBlockModel((BakedModel)event.getModels().get(resourceLocation)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetupConveyor(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ContainerConveyor.TYPE, GuiConveyor::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetupTransporter(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ContainerTransporter.TYPE, GuiTransporter::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClient() {
        EventManager.mod(FMLClientSetupEvent.class).process(this::onClientSetupConveyor).subscribe();
        EventManager.mod(ModelEvent.BakingCompleted.class).process(this::bakingCompleted).subscribe();
        EventManager.mod(ModelEvent.ModifyBakingResult.class).process(this::modifyBakingResult).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(this::onClientSetupTransporter).subscribe();
    }
}

