/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorInsertionUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTHBB = Shapes.m_83048_((double)0.125, (double)0.0, (double)-0.125, (double)0.875, (double)0.5625, (double)0.125);
    public static VoxelShape SOUTHBB = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.5625, (double)1.125);
    public static VoxelShape EASTBB = Shapes.m_83048_((double)0.875, (double)0.0, (double)0.125, (double)1.125, (double)0.5625, (double)0.875);
    public static VoxelShape WESTBB = Shapes.m_83048_((double)-0.125, (double)0.0, (double)0.125, (double)0.125, (double)0.5625, (double)0.875);
    public static VoxelShape NORTHBB_BIG = Shapes.m_83048_((double)0.125, (double)0.0, (double)-0.125, (double)0.875, (double)0.5625, (double)0.875);
    public static VoxelShape SOUTHBB_BIG = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5625, (double)1.125);
    public static VoxelShape EASTBB_BIG = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)1.125, (double)0.5625, (double)0.875);
    public static VoxelShape WESTBB_BIG = Shapes.m_83048_((double)-0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5625, (double)0.875);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private boolean fullArea = false;

    public ConveyorInsertionUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        if (this.getWorld().f_46443_) {
            return;
        }
        if (entity instanceof ItemEntity) {
            this.getHandlerCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (this.getWorkingBox().m_83215_().m_82338_(this.getPos()).m_82400_(0.01).m_82381_(entity.m_20191_())) {
                    if (this.whitelist != this.filter.matches((Entity)((ItemEntity)entity))) {
                        return;
                    }
                    ItemStack stack = ((ItemEntity)entity).m_32055_();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if ((stack = handler.insertItem(i, stack, false)).m_41619_()) {
                            ((ItemEntity)entity).m_32045_(ItemStack.f_41583_);
                            entity.m_142687_(Entity.RemovalReason.KILLED);
                            break;
                        }
                        ((ItemEntity)entity).m_32045_(stack);
                    }
                }
            });
        }
    }

    @Override
    public void update() {
        if (this.getWorld().f_46443_) {
            return;
        }
        if (this.getWorld().m_46467_() % 2L == 0L && this.getContainer() instanceof ConveyorTile) {
            FluidTank tank = ((ConveyorTile)this.getContainer()).getTank();
            this.getHandlerCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(arg_0 -> this.lambda$update$1((IFluidTank)tank, arg_0));
        }
    }

    private <T> LazyOptional<T> getHandlerCapability(Capability<T> capability) {
        BlockPos offsetPos = this.getPos().m_121945_(this.getSide());
        BlockEntity tile = this.getWorld().m_7702_(offsetPos);
        if (tile != null && tile.getCapability(capability, this.getSide().m_122424_()).isPresent()) {
            return tile.getCapability(capability, this.getSide().m_122424_());
        }
        Iterator iterator = this.getWorld().m_45976_(Entity.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82338_(offsetPos)).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            if (!entity.getCapability(capability, (entity = (Entity)iterator.next()) instanceof ServerPlayer ? null : this.getSide().m_122424_()).isPresent()) continue;
            return entity.getCapability(capability, entity instanceof ServerPlayer ? null : this.getSide().m_122424_());
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT() == null ? new CompoundTag() : super.serializeNBT();
        compound.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        compound.m_128379_("Whitelist", this.whitelist);
        compound.m_128379_("FullArea", this.fullArea);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.m_128441_("Filter")) {
            this.filter.deserializeNBT(nbt.m_128469_("Filter"));
        }
        this.whitelist = nbt.m_128471_("Whitelist");
        this.fullArea = nbt.m_128471_("FullArea");
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    private VoxelShape getWorkingBox() {
        if (!this.fullArea) {
            return this.getBoundingBox();
        }
        switch (this.getSide()) {
            default: {
                return NORTHBB_BIG;
            }
            case SOUTH: {
                return SOUTHBB_BIG;
            }
            case EAST: {
                return EASTBB_BIG;
            }
            case WEST: 
        }
        return WESTBB_BIG;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.m_41712_((CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.fullArea = !this.fullArea;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorInsertionUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorInsertionUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 55, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 39, 214, new String[]{"insert_near"}), new StateButtonInfo(1, res, 58, 214, new String[]{"insert_all"})}){

            @Override
            public int getState() {
                return ConveyorInsertionUpgrade.this.fullArea ? 1 : 0;
            }
        });
    }

    private /* synthetic */ void lambda$update$1(IFluidTank tank, IFluidHandler fluidHandler) {
        FluidStack drain;
        if (!tank.drain(50, IFluidHandler.FluidAction.SIMULATE).isEmpty() && fluidHandler.fill(tank.drain(50, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0 && this.whitelist == this.filter.matches(tank.drain(50, IFluidHandler.FluidAction.SIMULATE)) && !(drain = tank.drain(fluidHandler.fill(tank.drain(50, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drain.getAmount() > 0) {
            this.getContainer().requestFluidSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("insertion");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorInsertionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_inserter_" + upgradeSide.m_7912_().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_insertion_upgrade");
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).m_126130_("IPI").m_126130_("IDI").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50332_).m_126127_(Character.valueOf('C'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).m_176498_(consumer);
        }
    }
}

