/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FireworkGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "rocket";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.m_41720_() instanceof FireworkRocketItem && stack.m_41782_());
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).m_41613_() > 0) {
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0);
            Pair<Integer, Integer> power = this.calculate(stack);
            stack.m_41774_(1);
            return power;
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.RED};
    }

    @Override
    public Item getDisplay() {
        return Items.f_42688_;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes() {
        ArrayList<MycelialGeneratorRecipe> recipes = new ArrayList<MycelialGeneratorRecipe>();
        for (Item item : new Item[]{Items.f_42688_}) {
            for (int flight = 1; flight < 4; ++flight) {
                ItemStack stack = new ItemStack((ItemLike)item);
                CompoundTag tag = stack.m_41784_();
                CompoundTag flightTag = new CompoundTag();
                flightTag.m_128405_("Flight", flight);
                tag.m_128365_("Fireworks", (Tag)flightTag);
                stack.m_41751_(tag);
                Pair<Integer, Integer> power = this.calculate(stack);
                recipes.add(new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)power.getLeft(), (Integer)power.getRight()));
            }
        }
        return recipes;
    }

    public static FireworkRocketItem.Shape get(int indexIn) {
        return indexIn >= 0 && indexIn < FireworkRocketItem.Shape.values().length ? FireworkRocketItem.Shape.values()[indexIn] : FireworkRocketItem.Shape.SMALL_BALL;
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41720_() instanceof FireworkRocketItem && stack.m_41782_() && (nbt = stack.m_41737_("Fireworks")) != null) {
            int flight = nbt.m_128451_("Flight");
            double power = 1.0;
            ListTag listnbt = nbt.m_128437_("Explosions", 10);
            if (!listnbt.isEmpty()) {
                for (int i = 0; i < listnbt.size(); ++i) {
                    CompoundTag compound = listnbt.m_128728_(i);
                    FireworkRocketItem.Shape shape = FireworkGeneratorType.get(compound.m_128445_("Type"));
                    power *= this.getShapeModifier(shape);
                    int[] colors = compound.m_128465_("Colors");
                    power *= 1.0 + (double)colors.length / 100.0;
                    int[] fadeColors = compound.m_128465_("FadeColors");
                    power *= 1.0 + (double)fadeColors.length / 90.0;
                    if (compound.m_128471_("Trail")) {
                        power *= 1.6;
                    }
                    if (!compound.m_128471_("Flicker")) continue;
                    power *= 1.4;
                }
            }
            return Pair.of((Object)((int)(80.0 * power)), (Object)(60 * flight));
        }
        return Pair.of((Object)0, (Object)0);
    }

    private double getShapeModifier(FireworkRocketItem.Shape shape) {
        switch (shape) {
            case STAR: {
                return 1.2;
            }
            case BURST: {
                return 1.05;
            }
            case CREEPER: {
                return 1.5;
            }
            case LARGE_BALL: {
                return 1.1;
            }
        }
        return 1.01;
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42403_).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }

    @Override
    public void onTick(Level world, BlockPos pos) {
        AABB area = new AABB((double)(pos.m_123341_() - 3), (double)(pos.m_123342_() - 3), (double)(pos.m_123343_() - 3), (double)(pos.m_123341_() + 3), (double)(pos.m_123342_() + 3), (double)(pos.m_123343_() + 3));
        for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, area)) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 10, 2));
        }
    }
}

