/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Comparator;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class CreativeTabRegistry {
    public static Comparator<AbstractSpellPart> COMPARE_GLYPH_BY_TYPE = Comparator.comparingInt(AbstractSpellPart::getTypeIndex);
    public static Comparator<AbstractSpellPart> COMPARE_TYPE_THEN_NAME = COMPARE_GLYPH_BY_TYPE.thenComparing(AbstractSpellPart::getLocaleName);
    public static Comparator<AbstractSpellPart> COMPARE_TIER_THEN_NAME = COMPARE_GLYPH_BY_TYPE.thenComparingInt(o -> o.getConfigTier().value).thenComparing(AbstractSpellPart::getLocaleName);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"ars_nouveau");
    public static final RegistryObject<CreativeModeTab> BLOCKS = TABS.register("general", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.ars_nouveau")).m_257737_(() -> ItemsRegistry.CREATIVE_SPELLBOOK.get().m_7968_()).m_257501_((params, output) -> {
        for (RegistryObject entry : ItemsRegistry.ITEMS.getEntries()) {
            if (entry.get() instanceof Glyph) continue;
            output.m_246342_(((Item)entry.get()).m_7968_());
        }
        for (PerkItem perk : PerkRegistry.getPerkItemMap().values()) {
            output.m_246342_(perk.m_7968_());
        }
        for (RitualTablet ritual : RitualRegistry.getRitualItemMap().values()) {
            output.m_246342_(ritual.m_7968_());
        }
        for (FamiliarScript familiar : FamiliarRegistry.getFamiliarScriptMap().values()) {
            output.m_246342_(familiar.m_7968_());
        }
    }).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257652_());
    public static final RegistryObject<CreativeModeTab> GLYPHS = TABS.register("glyphs", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.ars_glyphs")).m_257737_(() -> MethodProjectile.INSTANCE.glyphItem.m_7968_()).m_257501_((params, output) -> {
        for (AbstractSpellPart glyph : GlyphRegistry.getSpellpartMap().values().stream().sorted(COMPARE_TYPE_THEN_NAME).toList()) {
            output.m_246342_(glyph.getGlyph().m_7968_());
        }
    }).withTabsBefore(new ResourceKey[]{BLOCKS.getKey()}).m_257652_());
}

