/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketWarpPosition;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class EffectBlink
extends AbstractEffect {
    public static EffectBlink INSTANCE = new EffectBlink();

    private EffectBlink() {
        super(GlyphLib.EffectBlinkID, "Blink");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity;
        ItemStack stack;
        WarpScroll.WarpScrollData data;
        InventoryManager manager;
        SlotReference reference;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        double distance = (double)((Integer)this.GENERIC_INT.get()).intValue() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        if (spellContext.getCaster() instanceof TileCaster && !(reference = (manager = spellContext.getCaster().getInvManager()).findItem(i -> i.m_41720_() == ItemsRegistry.WARP_SCROLL.m_5456_() || i.m_41720_() == ItemsRegistry.STABLE_WARP_SCROLL.m_5456_(), InteractType.EXTRACT)).isEmpty() && (data = WarpScroll.WarpScrollData.get(stack = reference.getHandler().getStackInSlot(reference.getSlot()))).isValid() && data.canTeleportWithDim(world)) {
            EffectBlink.warpEntity(rayTraceResult.m_82443_(), data);
            return;
        }
        if (rayTraceResult.m_82443_().equals((Object)shooter)) {
            EffectBlink.blinkForward(world, (Entity)shooter, distance);
            return;
        }
        if (this.isRealPlayer((Entity)shooter)) {
            WarpScroll.WarpScrollData scrollData = WarpScroll.WarpScrollData.get(shooter.m_21206_());
            if (scrollData.isValid()) {
                if (scrollData.isValid() && scrollData.canTeleportWithDim(world)) {
                    EffectBlink.warpEntity(rayTraceResult.m_82443_(), scrollData);
                }
            } else {
                shooter.m_6021_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
            }
        } else if (spellContext.getCaster().getCasterType() == SpellContext.CasterType.RUNE && (entity = rayTraceResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EffectBlink.blinkForward(world, (Entity)living, distance);
        }
    }

    public static void warpEntity(Entity entity, WarpScroll.WarpScrollData warpScrollData) {
        LivingEntity living;
        EntityTeleportEvent.EnderEntity event;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity && (event = ForgeEventFactory.onEnderTeleport((LivingEntity)(living = (LivingEntity)entity), (double)warpScrollData.getPos().m_123341_(), (double)warpScrollData.getPos().m_123342_(), (double)warpScrollData.getPos().m_123343_())).isCanceled()) {
            return;
        }
        ServerLevel dimension = PortalTile.getServerLevel(warpScrollData.getDimension(), (ServerLevel)entity.f_19853_);
        if (dimension == null) {
            return;
        }
        PortalTile.teleportEntityTo(entity, (Level)dimension, warpScrollData.getPos(), warpScrollData.getRotation());
    }

    public static void warpEntity(Entity entity, BlockPos warpPos) {
        LivingEntity living;
        EntityTeleportEvent.EnderEntity event;
        if (entity == null) {
            return;
        }
        Level world = entity.f_19853_;
        if (entity instanceof LivingEntity && (event = ForgeEventFactory.onEnderTeleport((LivingEntity)(living = (LivingEntity)entity), (double)warpPos.m_123341_(), (double)warpPos.m_123342_(), (double)warpPos.m_123343_())).isCanceled()) {
            return;
        }
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 4, (world.f_46441_.m_188500_() - 0.5) * 2.0, -world.f_46441_.m_188500_(), (world.f_46441_.m_188500_() - 0.5) * 2.0, (double)0.1f);
        entity.m_6021_((double)warpPos.m_123341_() + 0.5, (double)warpPos.m_123342_(), (double)warpPos.m_123343_() + 0.5);
        Networking.sendToNearby(world, entity, (Object)new PacketWarpPosition(entity.m_19879_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146909_(), entity.m_146908_()));
        entity.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12052_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)entity.m_20183_().m_123341_() + 0.5, (double)entity.m_20183_().m_123342_() + 1.0, (double)entity.m_20183_().m_123343_() + 0.5, 4, (world.f_46441_.m_188500_() - 0.5) * 2.0, -world.f_46441_.m_188500_(), (world.f_46441_.m_188500_() - 0.5) * 2.0, (double)0.1f);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 vec = rayTraceResult.m_82450_();
        if (this.isRealPlayer((Entity)shooter) && EffectBlink.isValidTeleport(world, rayTraceResult.m_82425_().m_121945_(rayTraceResult.m_82434_()))) {
            EffectBlink.warpEntity((Entity)shooter, BlockPos.m_274446_((Position)vec));
        }
    }

    public static void blinkForward(Level world, Entity shooter, double distance) {
        Vec3 lookVec = new Vec3(shooter.m_20154_().m_7096_(), 0.0, shooter.m_20154_().m_7094_());
        Vec3 vec = shooter.m_20182_().m_82549_(lookVec.m_82490_(distance));
        BlockPos pos = BlockPos.m_274446_((Position)vec);
        if (!EffectBlink.isValidTeleport(world, pos)) {
            BlockPos blockPos = pos = EffectBlink.getForward(world, pos, shooter, distance) == null ? EffectBlink.getForward(world, pos.m_6630_(2), shooter, distance) : EffectBlink.getForward(world, pos, shooter, distance);
        }
        if (pos == null) {
            return;
        }
        EffectBlink.warpEntity(shooter, pos);
    }

    public static BlockPos getForward(Level world, BlockPos pos, Entity shooter, double distance) {
        Vec3 lookVec = new Vec3(shooter.m_20154_().m_7096_(), 0.0, shooter.m_20154_().m_7094_());
        Vec3 oldVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82549_(lookVec.m_82490_(distance));
        for (double i = distance; i >= 0.0; i -= 1.0) {
            Vec3 vec = oldVec.m_82549_(lookVec.m_82490_(i));
            BlockPos sendPos = BlockPos.m_274446_((Position)vec);
            if (i <= 0.0) {
                return null;
            }
            if (!EffectBlink.isValidTeleport(world, sendPos)) continue;
            return sendPos;
        }
        return null;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 8, "Base teleport distance", "distance");
        this.addAmpConfig(builder, 3.0);
    }

    public static boolean isValidTeleport(Level world, BlockPos pos) {
        return !world.m_8055_(pos).m_60815_() && !world.m_8055_(pos.m_7494_()).m_60815_() && !world.m_8055_(pos.m_6630_(2)).m_60815_();
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Teleports the caster to a location. If an entity is hit and the caster is holding a Warp Scroll in the offhand, the entity will be warped to the location on the Warp Scroll. When used on Self, the caster blinks forward. Spell Turrets and Runes can warp entities using Warp Scrolls from adjacent inventories without consuming the scroll.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

