/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.particle.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.HelixParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketANEffect {
    private final EffectType type;
    private final double x;
    private final double y;
    private final double z;
    private final CompoundTag particleNbt;
    private final int[] args;

    public PacketANEffect(EffectType type, double x, double y, double z, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        ParticleColor defaultColor = new ParticleColor(255, 25, 180);
        this.particleNbt = defaultColor.serialize();
        this.args = args;
    }

    public PacketANEffect(EffectType type, double x, double y, double z, ParticleColor color, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.particleNbt = color.serialize();
        this.args = args;
    }

    public PacketANEffect(EffectType type, BlockPos pos, int ... args) {
        this(type, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), args);
    }

    public PacketANEffect(EffectType type, BlockPos pos, ParticleColor wrapper, int ... args) {
        this(type, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), wrapper, args);
    }

    public static PacketANEffect decode(FriendlyByteBuf buf) {
        EffectType type = EffectType.values()[buf.readByte()];
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        CompoundTag nbt = buf.m_130260_();
        int[] args = new int[type.argCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buf.m_130242_();
        }
        return new PacketANEffect(type, x, y, z, ParticleColorRegistry.from(nbt), args);
    }

    public static void encode(PacketANEffect msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.type.ordinal());
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.m_130079_(msg.particleNbt);
        for (int i = 0; i < msg.type.argCount; ++i) {
            buf.m_130130_(msg.args[i]);
        }
    }

    public static enum EffectType {
        TIMED_GLOW(4),
        TIMED_HELIX(0),
        BURST(0);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }

    public static class Handler {
        public static void handle(final PacketANEffect message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.m_91087_();
                    ClientLevel world = mc.f_91073_;
                    ParticleColor color = ParticleColorRegistry.from(message.particleNbt);
                    switch (message.type) {
                        case BURST: {
                            for (int i = 0; i < 10; ++i) {
                                double d0 = message.x + 0.5;
                                double d1 = message.y + 1.2;
                                double d2 = message.z + 0.5;
                                world.m_7106_(GlowParticleData.createData(color), d0, d1, d2, ((double)world.f_46441_.m_188501_() - 0.5) / 3.0, ((double)world.f_46441_.m_188501_() - 0.5) / 3.0, ((double)world.f_46441_.m_188501_() - 0.5) / 3.0);
                            }
                            break;
                        }
                        case TIMED_HELIX: {
                            int numParticles = 8;
                            for (int i = 0; i < numParticles; ++i) {
                                world.m_7106_(HelixParticleData.createData(color, 0.25f, 1.0f, 50, (float)i * 360.0f / (float)numParticles), message.x + 0.5, message.y + 0.1 * (double)i, message.z + 0.5, 0.0, 0.0, 0.0);
                            }
                            break;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

