/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.util.PortalFrameTester;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FlatPortalAreaHelper
extends PortalFrameTester {
    public int xSize = -1;
    public int zSize = -1;
    public final int maxXSize = 21;
    public final int maxZSize = 21;

    @Override
    public FlatPortalAreaHelper init(Level world, BlockPos blockPos, Direction.Axis axis, Predicate<BlockState> foundations) {
        this.VALID_FRAME = foundations;
        this.world = world;
        this.lowerCorner = this.getLowerCorner(blockPos, Direction.Axis.X, Direction.Axis.Z);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.zSize = 0;
            this.xSize = 0;
        } else {
            this.xSize = this.getSize(Direction.Axis.X, 1, 21);
            if (this.xSize > 0) {
                this.zSize = this.getSize(Direction.Axis.Z, 1, 21);
                if (this.checkForValidFrame(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize)) {
                    this.countExistingPortalBlocks(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize);
                } else {
                    this.lowerCorner = null;
                    this.zSize = 1;
                    this.xSize = 1;
                }
            }
        }
        return this;
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(Level worldAccess, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Predicate<BlockState> foundations) {
        return Optional.of(new FlatPortalAreaHelper().init(worldAccess, blockPos, axis, (Predicate)foundations)).filter(predicate);
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.xSize >= 1 && this.zSize >= 1 && this.xSize < 21 && this.zSize < 21;
    }

    @Override
    public void lightPortal(Block frameBlock) {
        BlockPos.m_121940_((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.m_5487_(Direction.Axis.X, this.xSize - 1).m_5487_(Direction.Axis.Z, this.zSize - 1)).forEach(blockPos -> this.world.m_7731_(blockPos, Blocks.f_50127_.m_49966_(), 18));
    }

    private void fillAirAroundPortal(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_280296_()) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    private void placeLandingPad(Level world, BlockPos pos, BlockState frameBlock) {
        if (!world.m_8055_(pos).m_280296_()) {
            world.m_46597_(pos, frameBlock);
        }
    }
}

