/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.part;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.PriorityMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.AppliedEConfig;
import gripe._90.appliede.me.misc.TransmutationPattern;
import gripe._90.appliede.me.service.KnowledgeService;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class EMCModulePart
extends AEBasePart
implements IStorageProvider,
ICraftingProvider,
IPriorityHost,
IGridTickable {
    @PartModels
    private static final IPartModel MODEL = new PartModel(AppliedE.id("part/emc_module"));
    private final Object2LongMap<AEKey> outputs = new Object2LongOpenHashMap();
    private int priority = 0;

    public EMCModulePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IStorageProvider.class, (IGridNodeService)this).addService(ICraftingProvider.class, (IGridNodeService)this).addService(IGridTickable.class, (IGridNodeService)this).setIdlePowerUsage(AppliedEConfig.CONFIG.getModuleEnergyUsage());
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128405_("priority", this.priority);
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.priority = data.m_128451_("priority");
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void mountInventories(IStorageMounts mounts) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            mounts.mount(((KnowledgeService)grid.getService(KnowledgeService.class)).getStorage(this.getMainNode()));
        }
    }

    public List<IPatternDetails> getAvailablePatterns() {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? ((KnowledgeService)grid.getService(KnowledgeService.class)).getPatterns(this.getMainNode()) : List.of();
    }

    public int getPatternPriority() {
        return this.priority;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!this.getMainNode().isActive() || !(patternDetails instanceof TransmutationPattern)) {
            return false;
        }
        TransmutationPattern pattern = (TransmutationPattern)patternDetails;
        GenericStack output = pattern.getPrimaryOutput();
        this.outputs.merge((Object)output.what(), output.amount(), Long::sum);
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
        return true;
    }

    public boolean isBusy() {
        return false;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, this.outputs.isEmpty(), true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        MEStorage storage = node.getGrid().getStorageService().getInventory();
        for (Object2LongMap.Entry output : new Object2LongOpenHashMap(this.outputs).object2LongEntrySet()) {
            long amount;
            AEKey what = (AEKey)output.getKey();
            long inserted = storage.insert(what, amount = output.getLongValue(), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
            if (inserted >= amount) {
                this.outputs.removeLong((Object)what);
                continue;
            }
            if (inserted <= 0L) continue;
            this.outputs.put((Object)what, amount - inserted);
        }
        return TickRateModulation.URGENT;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!player.m_20193_().m_5776_()) {
            MenuOpener.open((MenuType)PriorityMenu.TYPE, (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newPriority) {
        this.priority = newPriority;
        this.getHost().markForSave();
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        player.m_6915_();
    }

    public ItemStack getMainMenuIcon() {
        return ((Item)AppliedE.EMC_MODULE.get()).m_7968_();
    }
}

