/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.part;

import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.automation.IOBusPart;
import gripe._90.appliede.AppliedE;
import gripe._90.appliede.me.key.EMCKey;
import gripe._90.appliede.me.key.EMCKeyType;
import gripe._90.appliede.me.service.EMCStorage;
import gripe._90.appliede.me.service.KnowledgeService;
import java.util.concurrent.atomic.AtomicInteger;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMCExportBusPart
extends IOBusPart {
    private static final ResourceLocation MODEL_BASE = AppliedE.id("part/emc_export_bus");
    @PartModels
    private static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_off")});
    @PartModels
    private static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_on")});
    @PartModels
    private static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_has_channel")});
    private static final Logger LOGGER = LoggerFactory.getLogger(EMCExportBusPart.class);
    private int nextSlot = 0;

    public EMCExportBusPart(IPartItem<?> partItem) {
        super(TickRates.ExportBus, key -> AEItemKey.is((AEKey)key) || key == EMCKey.BASE, partItem);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
    }

    public void readFromNBT(CompoundTag extra) {
        super.readFromNBT(extra);
        this.nextSlot = extra.m_128451_("nextSlot");
    }

    public void writeToNBT(CompoundTag extra) {
        super.writeToNBT(extra);
        extra.m_128405_("nextSlot", this.nextSlot);
    }

    protected boolean doBusWork(IGrid grid) {
        BlockPos adjacentPos = this.getHost().getBlockEntity().m_58899_().m_121945_(this.getSide());
        Direction facing = this.getSide().m_122424_();
        BlockEntity blockEntity = this.getLevel().m_7702_(adjacentPos);
        if (blockEntity == null) {
            return false;
        }
        boolean doneWork = false;
        LazyOptional emcStorage = blockEntity.getCapability(PECapabilities.EMC_STORAGE_CAPABILITY, facing);
        LazyOptional itemHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing);
        EMCStorage networkEmc = ((KnowledgeService)grid.getService(KnowledgeService.class)).getStorage();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        AtomicInteger remaining = new AtomicInteger(this.getOperationsPerTick());
        int slot = 0;
        for (slot = 0; slot < this.availableSlots() && remaining.get() > 0; ++slot) {
            int startingSlot = switch (schedulingMode) {
                case SchedulingMode.RANDOM -> this.getLevel().m_213780_().m_188503_(this.availableSlots());
                case SchedulingMode.ROUNDROBIN -> (this.nextSlot + slot) % this.availableSlots();
                default -> slot;
            };
            AEKey what = this.getConfig().getKey(startingSlot);
            if (what == EMCKey.BASE) {
                emcStorage.ifPresent(handler -> {
                    int rem = remaining.get() * EMCKeyType.TYPE.getAmountPerOperation();
                    long insertable = handler.insertEmc((long)rem, IEmcStorage.EmcAction.SIMULATE);
                    long extracted = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)EMCKey.BASE, (long)insertable, (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                    if (extracted > 0L) {
                        handler.insertEmc(extracted, IEmcStorage.EmcAction.EXECUTE);
                        remaining.addAndGet((int)(-Math.max(1L, extracted / (long)EMCKeyType.TYPE.getAmountPerOperation())));
                    }
                });
                continue;
            }
            if (!(what instanceof AEItemKey)) continue;
            AEItemKey item = (AEItemKey)what;
            itemHandler.ifPresent(handler -> {
                ItemStack remainder;
                int rem = remaining.get();
                ItemStack stack = item.toStack(rem);
                long extracted = networkEmc.extractItem(item, rem, Actionable.SIMULATE, this.source, true);
                long wasInserted = extracted - (long)(remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true)).m_41613_();
                if (wasInserted > 0L && (wasInserted = (extracted = networkEmc.extractItem(item, rem, Actionable.MODULATE, this.source, true)) - (long)(remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false)).m_41613_()) < extracted) {
                    long leftover = extracted - wasInserted;
                    if ((leftover -= networkEmc.insertItem(item, leftover, Actionable.MODULATE, this.source, false, false, () -> {})) > 0L) {
                        LOGGER.error("Storage export: adjacent block unexpectedly refused insert, voided {}x{}", (Object)leftover, (Object)item);
                    }
                }
                if (wasInserted > 0L) {
                    remaining.addAndGet(-((int)wasInserted));
                }
            });
        }
        if (remaining.get() < this.getOperationsPerTick()) {
            if (schedulingMode == SchedulingMode.ROUNDROBIN) {
                this.nextSlot = (this.nextSlot + slot) % this.availableSlots();
            }
            doneWork = true;
        }
        return doneWork;
    }

    protected MenuType<?> getMenuType() {
        return (MenuType)AppliedE.EMC_EXPORT_BUS_MENU.get();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return this.isActive() ? MODELS_HAS_CHANNEL : (this.isPowered() ? MODELS_ON : MODELS_OFF);
    }
}

