/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.appliede.mixin.tooltip;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.BasePacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.common.MEStorageMenu;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import gripe._90.appliede.me.reporting.MEInventoryUpdatePacketBuilder;
import gripe._90.appliede.me.service.KnowledgeService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MEStorageMenu.class}, remap=false)
public abstract class MEStorageMenuMixin
extends AEBaseMenu {
    @Shadow
    @Nullable
    private IGridNode networkNode;
    @Shadow
    @Final
    private ITerminalHost host;
    @Shadow
    private Set<AEKey> previousCraftables;
    @Shadow
    private KeyCounter previousAvailableStacks;
    @Shadow
    @Final
    private IncrementalUpdateHelper updateHelper;
    @Unique
    private Set<AEItemKey> appliede$previousTransmutables = new HashSet<AEItemKey>();

    public MEStorageMenuMixin(MenuType<?> menuType, int id, Inventory playerInventory, ITerminalHost host) {
        super(menuType, id, playerInventory, (Object)host);
    }

    @Shadow
    protected abstract boolean showsCraftables();

    @Shadow
    public abstract boolean isKeyVisible(AEKey var1);

    @Shadow
    protected abstract void updatePowerStatus();

    @Unique
    private Set<AEItemKey> appliede$getTransmutablesFromGrid() {
        ITerminalHost iTerminalHost;
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && (iTerminalHost = this.host) instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)iTerminalHost;
            hostNode = actionHost.getActionableNode();
        }
        if (!this.showsCraftables()) {
            return Collections.emptySet();
        }
        return hostNode != null && hostNode.isActive() ? ((KnowledgeService)hostNode.getGrid().getService(KnowledgeService.class)).getKnownItems() : Collections.emptySet();
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="INVOKE", target="Lappeng/menu/me/common/IncrementalUpdateHelper;hasChanges()Z", remap=false)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, remap=true)
    private void replacePacket(CallbackInfo ci, Set<AEKey> craftable, KeyCounter availableStacks) {
        ci.cancel();
        Set<AEItemKey> transmutable = this.appliede$getTransmutablesFromGrid();
        Sets.difference(this.appliede$previousTransmutables, transmutable).forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
        Sets.difference(transmutable, this.appliede$previousTransmutables).forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
        if (this.updateHelper.hasChanges()) {
            MEInventoryUpdatePacketBuilder builder = new MEInventoryUpdatePacketBuilder(this.f_38840_, this.updateHelper.isFullUpdate());
            builder.setFilter(key -> this.isKeyVisible(key));
            builder.addChanges(this.updateHelper, availableStacks, craftable, new KeyCounter(), transmutable);
            builder.buildAndSend(packet -> this.sendPacketToClient((BasePacket)packet));
            this.updateHelper.commitChanges();
        }
        this.previousCraftables = ImmutableSet.copyOf(craftable);
        this.previousAvailableStacks = availableStacks;
        this.appliede$previousTransmutables = ImmutableSet.copyOf(transmutable);
        this.updatePowerStatus();
        super.m_38946_();
    }
}

