/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.registry;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import thedarkcolour.exdeorum.compat.CompatHelper;
import thedarkcolour.exdeorum.item.CompressedHammerItem;
import thedarkcolour.exdeorum.item.CookedSilkWormItem;
import thedarkcolour.exdeorum.item.CrookItem;
import thedarkcolour.exdeorum.item.GrassSpreaderItem;
import thedarkcolour.exdeorum.item.HammerItem;
import thedarkcolour.exdeorum.item.MeshItem;
import thedarkcolour.exdeorum.item.NyliumSpreaderItem;
import thedarkcolour.exdeorum.item.PorcelainBucket;
import thedarkcolour.exdeorum.item.PorcelainMilkBucket;
import thedarkcolour.exdeorum.item.RandomResultItem;
import thedarkcolour.exdeorum.item.SculkCoreItem;
import thedarkcolour.exdeorum.item.SilkWormItem;
import thedarkcolour.exdeorum.item.WateringCanItem;
import thedarkcolour.exdeorum.item.WideWateringCanItem;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.tag.EItemTags;

public class EItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"exdeorum");
    public static final RegistryObject<SilkWormItem> SILK_WORM = ITEMS.register("silk_worm", () -> new SilkWormItem(EItems.props()));
    public static final RegistryObject<Item> COOKED_SILK_WORM = ITEMS.register("cooked_silk_worm", () -> new CookedSilkWormItem(EItems.props().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.6f).m_38767_())));
    public static final RegistryObject<Item> CROOK = ITEMS.register("crook", () -> new CrookItem(EItems.props().m_41503_(128), 2.0f));
    public static final RegistryObject<Item> BONE_CROOK = ITEMS.register("bone_crook", () -> new CrookItem(EItems.props().m_41503_(312), 4.0f));
    public static final RegistryObject<Item> WOODEN_WATERING_CAN = ITEMS.register("wooden_watering_can", () -> new WateringCanItem(300, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> STONE_WATERING_CAN = ITEMS.register("stone_watering_can", () -> new WateringCanItem(1000, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> IRON_WATERING_CAN = ITEMS.register("iron_watering_can", () -> new WateringCanItem(2000, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> GOLDEN_WATERING_CAN = ITEMS.register("golden_watering_can", () -> new WateringCanItem(4000, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> DIAMOND_WATERING_CAN = ITEMS.register("diamond_watering_can", () -> new WideWateringCanItem(false, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> NETHERITE_WATERING_CAN = ITEMS.register("netherite_watering_can", () -> new WideWateringCanItem(true, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> STRING_MESH = ITEMS.register("string_mesh", () -> new MeshItem(EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> FLINT_MESH = ITEMS.register("flint_mesh", () -> new MeshItem(EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> IRON_MESH = ITEMS.register("iron_mesh", () -> new MeshItem(EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> GOLDEN_MESH = ITEMS.register("golden_mesh", () -> new MeshItem(EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> DIAMOND_MESH = ITEMS.register("diamond_mesh", () -> new MeshItem(EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> NETHERITE_MESH = ITEMS.register("netherite_mesh", () -> new MeshItem(EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> WOODEN_HAMMER = ITEMS.register("wooden_hammer", () -> new HammerItem((Tier)Tiers.WOOD, EItems.props()));
    public static final RegistryObject<Item> STONE_HAMMER = ITEMS.register("stone_hammer", () -> new HammerItem((Tier)Tiers.STONE, EItems.props()));
    public static final RegistryObject<Item> GOLDEN_HAMMER = ITEMS.register("golden_hammer", () -> new HammerItem((Tier)Tiers.GOLD, EItems.props()));
    public static final RegistryObject<Item> IRON_HAMMER = ITEMS.register("iron_hammer", () -> new HammerItem((Tier)Tiers.IRON, EItems.props()));
    public static final RegistryObject<Item> DIAMOND_HAMMER = ITEMS.register("diamond_hammer", () -> new HammerItem((Tier)Tiers.DIAMOND, EItems.props()));
    public static final RegistryObject<Item> NETHERITE_HAMMER = ITEMS.register("netherite_hammer", () -> new HammerItem((Tier)Tiers.NETHERITE, EItems.props()));
    public static final RegistryObject<Item> COMPRESSED_WOODEN_HAMMER = ITEMS.register("compressed_wooden_hammer", () -> new CompressedHammerItem((Tier)Tiers.WOOD, EItems.props()));
    public static final RegistryObject<Item> COMPRESSED_STONE_HAMMER = ITEMS.register("compressed_stone_hammer", () -> new CompressedHammerItem((Tier)Tiers.STONE, EItems.props()));
    public static final RegistryObject<Item> COMPRESSED_GOLDEN_HAMMER = ITEMS.register("compressed_golden_hammer", () -> new CompressedHammerItem((Tier)Tiers.GOLD, EItems.props()));
    public static final RegistryObject<Item> COMPRESSED_IRON_HAMMER = ITEMS.register("compressed_iron_hammer", () -> new CompressedHammerItem((Tier)Tiers.IRON, EItems.props()));
    public static final RegistryObject<Item> COMPRESSED_DIAMOND_HAMMER = ITEMS.register("compressed_diamond_hammer", () -> new CompressedHammerItem((Tier)Tiers.DIAMOND, EItems.props()));
    public static final RegistryObject<Item> COMPRESSED_NETHERITE_HAMMER = ITEMS.register("compressed_netherite_hammer", () -> new CompressedHammerItem((Tier)Tiers.NETHERITE, EItems.props()));
    public static final RegistryObject<Item> IRON_ORE_CHUNK = EItems.registerSimpleItem("iron_ore_chunk");
    public static final RegistryObject<Item> COPPER_ORE_CHUNK = EItems.registerSimpleItem("copper_ore_chunk");
    public static final RegistryObject<Item> GOLD_ORE_CHUNK = EItems.registerSimpleItem("gold_ore_chunk");
    public static final RegistryObject<Item> ALUMINUM_ORE_CHUNK = EItems.registerSimpleItem("aluminum_ore_chunk");
    public static final RegistryObject<Item> COBALT_ORE_CHUNK = EItems.registerSimpleItem("cobalt_ore_chunk");
    public static final RegistryObject<Item> SILVER_ORE_CHUNK = EItems.registerSimpleItem("silver_ore_chunk");
    public static final RegistryObject<Item> LEAD_ORE_CHUNK = EItems.registerSimpleItem("lead_ore_chunk");
    public static final RegistryObject<Item> PLATINUM_ORE_CHUNK = EItems.registerSimpleItem("platinum_ore_chunk");
    public static final RegistryObject<Item> NICKEL_ORE_CHUNK = EItems.registerSimpleItem("nickel_ore_chunk");
    public static final RegistryObject<Item> URANIUM_ORE_CHUNK = EItems.registerSimpleItem("uranium_ore_chunk");
    public static final RegistryObject<Item> OSMIUM_ORE_CHUNK = EItems.registerSimpleItem("osmium_ore_chunk");
    public static final RegistryObject<Item> TIN_ORE_CHUNK = EItems.registerSimpleItem("tin_ore_chunk");
    public static final RegistryObject<Item> ZINC_ORE_CHUNK = EItems.registerSimpleItem("zinc_ore_chunk");
    public static final RegistryObject<Item> IRIDIUM_ORE_CHUNK = EItems.registerSimpleItem("iridium_ore_chunk");
    public static final RegistryObject<Item> THORIUM_ORE_CHUNK = EItems.registerSimpleItem("thorium_ore_chunk");
    public static final RegistryObject<Item> MAGNESIUM_ORE_CHUNK = EItems.registerSimpleItem("magnesium_ore_chunk");
    public static final RegistryObject<Item> LITHIUM_ORE_CHUNK = EItems.registerSimpleItem("lithium_ore_chunk");
    public static final RegistryObject<Item> BORON_ORE_CHUNK = EItems.registerSimpleItem("boron_ore_chunk");
    public static final RegistryObject<Item> STONE_PEBBLE = EItems.registerSimpleItem("stone_pebble");
    public static final RegistryObject<Item> DIORITE_PEBBLE = EItems.registerSimpleItem("diorite_pebble");
    public static final RegistryObject<Item> GRANITE_PEBBLE = EItems.registerSimpleItem("granite_pebble");
    public static final RegistryObject<Item> ANDESITE_PEBBLE = EItems.registerSimpleItem("andesite_pebble");
    public static final RegistryObject<Item> DEEPSLATE_PEBBLE = EItems.registerSimpleItem("deepslate_pebble");
    public static final RegistryObject<Item> TUFF_PEBBLE = EItems.registerSimpleItem("tuff_pebble");
    public static final RegistryObject<Item> CALCITE_PEBBLE = EItems.registerSimpleItem("calcite_pebble");
    public static final RegistryObject<Item> BLACKSTONE_PEBBLE = EItems.registerSimpleItem("blackstone_pebble");
    public static final RegistryObject<Item> BASALT_PEBBLE = EItems.registerSimpleItem("basalt_pebble");
    public static final RegistryObject<Item> PORCELAIN_CLAY_BALL = EItems.registerSimpleItem("porcelain_clay_ball");
    public static final RegistryObject<Item> GRASS_SEEDS = ITEMS.register("grass_seeds", () -> new GrassSpreaderItem(EItems.props(), () -> ((Block)Blocks.f_50440_).m_49966_()));
    public static final RegistryObject<Item> MYCELIUM_SPORES = ITEMS.register("mycelium_spores", () -> new GrassSpreaderItem(EItems.props(), () -> ((Block)Blocks.f_50195_).m_49966_()));
    public static final RegistryObject<Item> WARPED_NYLIUM_SPORES = ITEMS.register("warped_nylium_spores", () -> new NyliumSpreaderItem(EItems.props(), () -> ((Block)Blocks.f_50690_).m_49966_()));
    public static final RegistryObject<Item> CRIMSON_NYLIUM_SPORES = ITEMS.register("crimson_nylium_spores", () -> new NyliumSpreaderItem(EItems.props(), () -> ((Block)Blocks.f_50699_).m_49966_()));
    public static final RegistryObject<Item> SCULK_CORE = ITEMS.register("sculk_core", () -> new SculkCoreItem(EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> RANDOM_POTTERY_SHERD = ITEMS.register("random_pottery_sherd", () -> new RandomResultItem.RandomSherd(EItems.props()));
    public static final RegistryObject<Item> RANDOM_ARMOR_TRIM = ITEMS.register("random_armor_trim", () -> new RandomResultItem.RandomArmorTrim(EItems.props()));
    public static final RegistryObject<Item> WOOD_CHIPPINGS = EItems.registerSimpleItem("wood_chippings");
    public static final RegistryObject<Item> UNFIRED_PORCELAIN_BUCKET = EItems.registerSimpleItem("unfired_porcelain_bucket");
    public static final RegistryObject<Item> PORCELAIN_BUCKET = ITEMS.register("porcelain_bucket", () -> new PorcelainBucket(() -> Fluids.f_76191_, EItems.props().m_41487_(16)));
    public static final RegistryObject<Item> PORCELAIN_WATER_BUCKET = ITEMS.register("porcelain_water_bucket", () -> new PorcelainBucket(() -> Fluids.f_76193_, EItems.props().m_41495_((Item)PORCELAIN_BUCKET.get()).m_41487_(1)));
    public static final RegistryObject<Item> PORCELAIN_LAVA_BUCKET = ITEMS.register("porcelain_lava_bucket", () -> new PorcelainBucket(() -> Fluids.f_76195_, EItems.props().m_41487_(1)));
    public static final RegistryObject<Item> PORCELAIN_MILK_BUCKET = ITEMS.register("porcelain_milk_bucket", () -> new PorcelainMilkBucket(EItems.props().m_41495_((Item)PORCELAIN_BUCKET.get()).m_41487_(1)));
    public static final RegistryObject<Item> PORCELAIN_WITCH_WATER_BUCKET = ITEMS.register("porcelain_witch_water_bucket", () -> new PorcelainBucket((Supplier<? extends Fluid>)EFluids.WITCH_WATER, EItems.props().m_41495_((Item)PORCELAIN_BUCKET.get()).m_41487_(1)));
    public static final RegistryObject<Item> WITCH_WATER_BUCKET = ITEMS.register("witch_water_bucket", () -> new BucketItem(EFluids.WITCH_WATER, EItems.props().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<BlockItem> DUST = EItems.registerItemBlock(EBlocks.DUST);
    public static final RegistryObject<BlockItem> CRUSHED_NETHERRACK = EItems.registerItemBlock(EBlocks.CRUSHED_NETHERRACK);
    public static final RegistryObject<BlockItem> CRUSHED_END_STONE = EItems.registerItemBlock(EBlocks.CRUSHED_END_STONE);
    public static final RegistryObject<BlockItem> CRUSHED_DEEPSLATE = EItems.registerItemBlock(EBlocks.CRUSHED_DEEPSLATE);
    public static final RegistryObject<BlockItem> CRUSHED_BLACKSTONE = EItems.registerItemBlock(EBlocks.CRUSHED_BLACKSTONE);
    public static final RegistryObject<BlockItem> MECHANICAL_SIEVE = EItems.registerItemBlock(EBlocks.MECHANICAL_SIEVE);
    public static final RegistryObject<BlockItem> MECHANICAL_HAMMER = EItems.registerItemBlock(EBlocks.MECHANICAL_HAMMER);
    public static final RegistryObject<BlockItem> UNFIRED_PORCELAIN_CRUCIBLE = EItems.registerItemBlock(EBlocks.UNFIRED_PORCELAIN_CRUCIBLE);
    public static final RegistryObject<BlockItem> END_CAKE = EItems.registerItemBlock(EBlocks.END_CAKE);
    public static final RegistryObject<BlockItem> INFESTED_LEAVES = EItems.registerItemBlock(EBlocks.INFESTED_LEAVES);

    public static RegistryObject<Item> registerSimpleItem(String name) {
        return ITEMS.register(name, () -> new Item(EItems.props()));
    }

    public static Item.Properties props() {
        return new Item.Properties();
    }

    public static RegistryObject<BlockItem> registerItemBlock(RegistryObject<? extends Block> block) {
        return ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), EItems.props()));
    }

    public static void addItemsToMainTab(CreativeModeTab.Output output) {
        for (ItemLike material : Iterables.concat(CompatHelper.getAvailableBarrels(true), CompatHelper.getAvailableSieves(true, false), CompatHelper.getAvailableCompressedSieves(true))) {
            output.m_246326_(material);
        }
        output.m_246326_((ItemLike)MECHANICAL_SIEVE.get());
        output.m_246326_((ItemLike)MECHANICAL_HAMMER.get());
        output.m_246326_((ItemLike)UNFIRED_PORCELAIN_CRUCIBLE.get());
        for (ItemLike material : Iterables.concat(CompatHelper.getAvailableLavaCrucibles(true), CompatHelper.getAvailableWaterCrucibles(true))) {
            output.m_246326_(material);
        }
        output.m_246326_((ItemLike)DUST.get());
        output.m_246326_((ItemLike)CRUSHED_NETHERRACK.get());
        output.m_246326_((ItemLike)CRUSHED_END_STONE.get());
        output.m_246326_((ItemLike)CRUSHED_DEEPSLATE.get());
        output.m_246326_((ItemLike)CRUSHED_BLACKSTONE.get());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_DIRT.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_COBBLESTONE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_DIORITE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_GRANITE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_ANDESITE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_GRAVEL.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_SAND.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_DUST.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_RED_SAND.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_DEEPSLATE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_COBBLED_DEEPSLATE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_NETHERRACK.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_BLACKSTONE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_END_STONE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_DEEPSLATE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_BLACKSTONE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_NETHERRACK.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_SOUL_SAND.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_END_STONE.getItem());
        output.m_246326_((ItemLike)ECompressedBlocks.COMPRESSED_MOSS_BLOCK.getItem());
        output.m_246326_((ItemLike)END_CAKE.get());
        output.m_246326_((ItemLike)RANDOM_ARMOR_TRIM.get());
        output.m_246326_((ItemLike)RANDOM_POTTERY_SHERD.get());
        output.m_246326_((ItemLike)SILK_WORM.get());
        output.m_246326_((ItemLike)COOKED_SILK_WORM.get());
        output.m_246326_((ItemLike)CROOK.get());
        output.m_246326_((ItemLike)BONE_CROOK.get());
        List<RegistryObject<Item>> wateringCans = List.of(WOODEN_WATERING_CAN, STONE_WATERING_CAN, IRON_WATERING_CAN, GOLDEN_WATERING_CAN, DIAMOND_WATERING_CAN, NETHERITE_WATERING_CAN);
        for (RegistryObject<Item> wateringCan : wateringCans) {
            ItemStack full = WateringCanItem.getFull(wateringCan);
            output.m_246326_((ItemLike)wateringCan.get());
            output.m_246342_(full);
        }
        output.m_246326_((ItemLike)STRING_MESH.get());
        output.m_246326_((ItemLike)FLINT_MESH.get());
        output.m_246326_((ItemLike)IRON_MESH.get());
        output.m_246326_((ItemLike)GOLDEN_MESH.get());
        output.m_246326_((ItemLike)DIAMOND_MESH.get());
        output.m_246326_((ItemLike)NETHERITE_MESH.get());
        output.m_246326_((ItemLike)WOODEN_HAMMER.get());
        output.m_246326_((ItemLike)STONE_HAMMER.get());
        output.m_246326_((ItemLike)GOLDEN_HAMMER.get());
        output.m_246326_((ItemLike)IRON_HAMMER.get());
        output.m_246326_((ItemLike)DIAMOND_HAMMER.get());
        output.m_246326_((ItemLike)NETHERITE_HAMMER.get());
        output.m_246326_((ItemLike)COMPRESSED_WOODEN_HAMMER.get());
        output.m_246326_((ItemLike)COMPRESSED_STONE_HAMMER.get());
        output.m_246326_((ItemLike)COMPRESSED_GOLDEN_HAMMER.get());
        output.m_246326_((ItemLike)COMPRESSED_IRON_HAMMER.get());
        output.m_246326_((ItemLike)COMPRESSED_DIAMOND_HAMMER.get());
        output.m_246326_((ItemLike)COMPRESSED_NETHERITE_HAMMER.get());
        output.m_246326_((ItemLike)IRON_ORE_CHUNK.get());
        output.m_246326_((ItemLike)COPPER_ORE_CHUNK.get());
        output.m_246326_((ItemLike)GOLD_ORE_CHUNK.get());
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_ALUMINUM)) {
            output.m_246326_((ItemLike)ALUMINUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_COBALT)) {
            output.m_246326_((ItemLike)COBALT_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_SILVER)) {
            output.m_246326_((ItemLike)SILVER_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_LEAD)) {
            output.m_246326_((ItemLike)LEAD_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_PLATINUM)) {
            output.m_246326_((ItemLike)PLATINUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_NICKEL)) {
            output.m_246326_((ItemLike)NICKEL_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_URANIUM)) {
            output.m_246326_((ItemLike)URANIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_OSMIUM)) {
            output.m_246326_((ItemLike)OSMIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_TIN)) {
            output.m_246326_((ItemLike)TIN_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_ZINC)) {
            output.m_246326_((ItemLike)ZINC_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_IRIDIUM)) {
            output.m_246326_((ItemLike)IRIDIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_THORIUM)) {
            output.m_246326_((ItemLike)THORIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_MAGNESIUM)) {
            output.m_246326_((ItemLike)MAGNESIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_LITHIUM)) {
            output.m_246326_((ItemLike)LITHIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_BORON)) {
            output.m_246326_((ItemLike)BORON_ORE_CHUNK.get());
        }
        output.m_246326_((ItemLike)STONE_PEBBLE.get());
        output.m_246326_((ItemLike)DIORITE_PEBBLE.get());
        output.m_246326_((ItemLike)GRANITE_PEBBLE.get());
        output.m_246326_((ItemLike)ANDESITE_PEBBLE.get());
        output.m_246326_((ItemLike)DEEPSLATE_PEBBLE.get());
        output.m_246326_((ItemLike)TUFF_PEBBLE.get());
        output.m_246326_((ItemLike)CALCITE_PEBBLE.get());
        output.m_246326_((ItemLike)BLACKSTONE_PEBBLE.get());
        output.m_246326_((ItemLike)BASALT_PEBBLE.get());
        output.m_246326_((ItemLike)GRASS_SEEDS.get());
        output.m_246326_((ItemLike)MYCELIUM_SPORES.get());
        output.m_246326_((ItemLike)WARPED_NYLIUM_SPORES.get());
        output.m_246326_((ItemLike)CRIMSON_NYLIUM_SPORES.get());
        output.m_246326_((ItemLike)SCULK_CORE.get());
        output.m_246326_((ItemLike)WOOD_CHIPPINGS.get());
        output.m_246326_((ItemLike)PORCELAIN_CLAY_BALL.get());
        output.m_246326_((ItemLike)UNFIRED_PORCELAIN_BUCKET.get());
        output.m_246326_((ItemLike)PORCELAIN_BUCKET.get());
        output.m_246326_((ItemLike)PORCELAIN_WATER_BUCKET.get());
        output.m_246326_((ItemLike)PORCELAIN_LAVA_BUCKET.get());
        output.m_246326_((ItemLike)PORCELAIN_MILK_BUCKET.get());
        output.m_246326_((ItemLike)PORCELAIN_WITCH_WATER_BUCKET.get());
        output.m_246326_((ItemLike)WITCH_WATER_BUCKET.get());
    }
}

