/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BlockPredicate
extends Predicate<BlockState> {
    public static final byte SINGLE_BLOCK = 0;
    public static final byte BLOCK_STATE = 1;
    public static final byte BLOCK_TAG = 2;

    public JsonObject toJson();

    public void toNetwork(FriendlyByteBuf var1);

    public Stream<BlockState> possibleStates();

    public static BlockPredicate singleBlock(Block block) {
        return new SingleBlockPredicate(block);
    }

    public static BlockPredicate blockState(Block block, StatePropertiesPredicate properties) {
        return new BlockStatePredicate(block, properties);
    }

    public static BlockPredicate blockTag(TagKey<Block> tag) {
        return new TagPredicate(tag);
    }

    @Nullable
    public static BlockPredicate fromJson(@Nullable JsonObject json) {
        if (json == null) {
            return null;
        }
        if (json.has("block")) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(json.get("block").getAsString()));
            if (block == Blocks.f_50016_) {
                return null;
            }
            if (json.has("state")) {
                return new BlockStatePredicate(block, StatePropertiesPredicate.m_67679_((JsonElement)json.get("state")));
            }
            return new SingleBlockPredicate(block);
        }
        if (json.has("block_tag")) {
            return new TagPredicate((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(json.get("block_tag").getAsString())));
        }
        return null;
    }

    @Nullable
    public static BlockPredicate fromNetwork(FriendlyByteBuf buffer) {
        return switch (buffer.readByte()) {
            case 0 -> new SingleBlockPredicate((Block)buffer.m_236816_((IdMap)BuiltInRegistries.f_256975_));
            case 1 -> new BlockStatePredicate((Block)buffer.m_236816_((IdMap)BuiltInRegistries.f_256975_), StatePropertiesPredicate.m_67679_((JsonElement)JsonParser.parseString((String)buffer.m_130277_())));
            case 2 -> new TagPredicate((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)buffer.m_130281_()));
            default -> null;
        };
    }

    public record SingleBlockPredicate(Block block) implements BlockPredicate
    {
        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("block", BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString());
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(0);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)this.block);
        }

        @Override
        public boolean test(BlockState state) {
            return state.m_60713_(this.block);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return this.block.m_49965_().m_61056_().stream();
        }
    }

    public record BlockStatePredicate(Block block, StatePropertiesPredicate properties) implements BlockPredicate
    {
        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("block", BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString());
            json.add("state", this.properties.m_67666_());
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(1);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)this.block);
            buffer.m_130070_(this.properties.m_67666_().toString());
        }

        @Override
        public boolean test(BlockState state) {
            return state.m_60713_(this.block) && this.properties.m_67667_(state);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return this.block.m_49965_().m_61056_().stream().filter(arg_0 -> ((StatePropertiesPredicate)this.properties).m_67667_(arg_0));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockStatePredicate that = (BlockStatePredicate)o;
            return Objects.equals(this.block, that.block) && Objects.equals(this.properties.m_67666_(), that.properties.m_67666_());
        }
    }

    public record TagPredicate(TagKey<Block> tag) implements BlockPredicate
    {
        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("block_tag", this.tag.f_203868_().toString());
            return json;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeByte(2);
            buffer.m_130085_(this.tag.f_203868_());
        }

        @Override
        public boolean test(BlockState state) {
            return state.m_204336_(this.tag);
        }

        @Override
        public Stream<BlockState> possibleStates() {
            return StreamSupport.stream(BuiltInRegistries.f_256975_.m_206058_(this.tag).spliterator(), false).filter(holder -> holder.m_203656_(this.tag)).flatMap(holder -> ((Block)holder.get()).m_49965_().m_61056_().stream());
        }
    }
}

