/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.event;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.client.ClientsideCode;
import thedarkcolour.exdeorum.client.CompostColors;
import thedarkcolour.exdeorum.compat.top.ExDeorumTopCompat;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.item.WateringCanItem;
import thedarkcolour.exdeorum.material.AbstractCrucibleMaterial;
import thedarkcolour.exdeorum.material.BarrelMaterial;
import thedarkcolour.exdeorum.network.NetworkHandler;
import thedarkcolour.exdeorum.network.VisualUpdateTracker;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.tag.EBiomeTags;
import thedarkcolour.exdeorum.voidworld.VoidChunkGenerator;

public final class EventHandler {
    public static void register() {
        IEventBus fmlBus = MinecraftForge.EVENT_BUS;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        fmlBus.addListener(EventHandler::onPlayerLogin);
        fmlBus.addListener(EventHandler::onDataSynced);
        fmlBus.addListener(EventHandler::addReloadListeners);
        fmlBus.addListener(EventHandler::createSpawnTree);
        modBus.addListener(EventHandler::interModEnqueue);
        modBus.addListener(EventHandler::onCommonSetup);
        fmlBus.addListener(EventHandler::serverShutdown);
        fmlBus.addListener(EventHandler::serverTick);
        if (ExDeorum.DEBUG) {
            fmlBus.addListener(EventHandler::handleDebugCommands);
        }
    }

    private static void serverShutdown(ServerStoppingEvent event) {
        RecipeUtil.unload();
    }

    private static void handleDebugCommands(ClientChatEvent event) {
        if (event.getMessage().equals(".compost_colors")) {
            event.setCanceled(true);
            try {
                CompostColors.loadColors();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.m_5661_((Component)Component.m_237113_((String)("Reloaded " + CompostColors.COLORS.size() + " compost colors!")), false);
                }
            }
            catch (Exception e) {
                ExDeorum.LOGGER.error("Failed to load vanilla compost colors", (Throwable)e);
            }
        } else if (event.getMessage().equals(".breakpoint")) {
            event.setCanceled(true);
        }
    }

    private static void createSpawnTree(LevelEvent.CreateSpawnPosition event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_7726_().m_8481_() instanceof VoidChunkGenerator) {
            Holder.Reference value;
            XoroshiroRandomSource rand = new XoroshiroRandomSource(level.m_7328_());
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(rand.m_216332_(-200, 200), 64, rand.m_216332_(-200, 200));
            level.m_7731_((BlockPos)pos, Blocks.f_50493_.m_49966_(), 2);
            pos.m_122184_(0, 1, 0);
            Registry configuredFeatureRegistry = level.m_9598_().m_175515_(Registries.f_256911_);
            ResourceKey defaultTreeFeature = TreeFeatures.f_195142_;
            ResourceLocation defaultTreeFeatureLoc = ResourceLocation.m_135820_((String)((String)EConfig.SERVER.defaultSpawnTreeFeature.get()));
            Holder holder = configuredFeatureRegistry.m_203636_(defaultTreeFeature).orElse(null);
            if (defaultTreeFeatureLoc != null && (value = (Holder.Reference)configuredFeatureRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)defaultTreeFeatureLoc)).orElse(null)) != null) {
                holder = value;
            }
            if (((Boolean)EConfig.SERVER.useBiomeAppropriateTree.get()).booleanValue()) {
                Holder biome = level.m_204166_((BlockPos)pos);
                for (Map.Entry<TagKey<Biome>, RegistryObject<ConfiguredFeature<?, ?>>> entry : EBiomeTags.TREE_TAGS.entrySet()) {
                    Optional optional;
                    if (!biome.m_203656_(entry.getKey()) || !(optional = entry.getValue().getHolder()).isPresent()) continue;
                    holder = (Holder)optional.get();
                    break;
                }
            }
            if (holder == null || !((ConfiguredFeature)holder.m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), (RandomSource)rand, (BlockPos)pos)) {
                ExDeorum.LOGGER.error("Failed to generate spawn tree :(");
            } else {
                ExDeorum.LOGGER.debug("Generated spawn tree at {}", (Object)pos);
            }
            event.setCanceled(true);
            event.getSettings().m_7250_(level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)pos), 90.0f);
            ((GameRules.IntegerValue)level.m_46469_().m_46170_(GameRules.f_46147_)).m_151489_(0, level.m_7654_());
        }
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        CompostColors.loadColors();
        event.enqueueWork(() -> {
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)EFluids.WITCH_WATER_TYPE.get(), fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : ((Boolean)EConfig.SERVER.witchWaterNetherrackGenerator.get() != false ? Blocks.f_50134_.m_49966_() : Blocks.f_50652_.m_49966_())));
            BlockState[] dirtVariants = new BlockState[]{Blocks.f_50493_.m_49966_(), Blocks.f_50599_.m_49966_(), Blocks.f_50546_.m_49966_()};
            RandomSource rng = RandomSource.m_216327_();
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)EFluids.WITCH_WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, pos, relative, state) -> level.m_6425_(relative).getFluidType() == ForgeMod.WATER_TYPE.get() && (Boolean)EConfig.SERVER.witchWaterDirtGenerator.get() != false, fluidState -> (BlockState)Util.m_214670_((Object[])dirtVariants, (RandomSource)rng)));
            BarrelMaterial.loadTransparentBlocks();
            AbstractCrucibleMaterial.loadTransparentBlocks();
            DispenserBlock.m_52672_((ItemLike)((ItemLike)EItems.WITCH_WATER_BUCKET.get()), (DispenseItemBehavior)((DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42447_)));
        });
    }

    private static void onDataSynced(OnDatapackSyncEvent event) {
        UUID excludedUUID = null;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientsideCode::getLocalPlayer);
            if (player == null) {
                return;
            }
            excludedUUID = player.m_20148_();
        }
        HashSet<ServerPlayer> players = new HashSet<ServerPlayer>(event.getPlayerList().m_11314_());
        if (event.getPlayer() != null) {
            players.add(event.getPlayer());
        }
        for (ServerPlayer player : players) {
            if (player.m_20148_().equals(excludedUUID)) continue;
            NetworkHandler.sendRecipeCacheReset(player);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        ChunkGenerator generator;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ((generator = (player = (ServerPlayer)player2).m_284548_().m_7726_().m_8481_()) instanceof VoidChunkGenerator || generator.getClass().getName().toLowerCase(Locale.ROOT).contains("skyblock"))) {
            NetworkHandler.sendVoidWorld(player);
            Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("exdeorum", "core/root"));
            if (advancement != null) {
                if (!player.m_8960_().m_135996_(advancement).m_8193_()) {
                    player.m_8960_().m_135988_(advancement, "in_void_world");
                    if (((Boolean)EConfig.SERVER.startingTorch.get()).booleanValue()) {
                        player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42000_));
                    }
                    if (((Boolean)EConfig.SERVER.startingWateringCan.get()).booleanValue()) {
                        player.m_150109_().m_36054_(WateringCanItem.getFull(EItems.WOODEN_WATERING_CAN));
                    }
                }
            } else {
                ExDeorum.LOGGER.error("Unable to grant player the Void World advancement. Ex Deorum advancements will not show");
            }
        }
    }

    private static void interModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", ExDeorumTopCompat::new);
        }
        if (ModList.get().isLoaded("inventorysorter")) {
            InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", ItemHelper.Slot.class::getName);
        }
    }

    private static void addReloadListeners(AddReloadListenerEvent event) {
        RecipeManager recipes = event.getServerResources().m_206887_();
        event.addListener((prepBarrier, resourceManager, prepProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> prepBarrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> RecipeUtil.reload(recipes), gameExecutor));
    }

    private static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            VisualUpdateTracker.syncVisualUpdates();
        }
    }
}

