/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.data;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.WorldPresetTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.material.Fluid;
import thedarkcolour.exdeorum.block.CompressedBlockType;
import thedarkcolour.exdeorum.data.ModCompatData;
import thedarkcolour.exdeorum.material.AbstractMaterial;
import thedarkcolour.exdeorum.material.BarrelMaterial;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.tag.EBlockTags;
import thedarkcolour.exdeorum.tag.EItemTags;
import thedarkcolour.exdeorum.tag.EStructureSetTags;
import thedarkcolour.modkit.data.DirectTagAppender;
import thedarkcolour.modkit.data.MKTagsProvider;

class ModTags {
    private static final List<BarrelMaterial> STONE_MATERIALS = List.of(DefaultMaterials.STONE_BARREL, DefaultMaterials.CRYSTALLIZED_BARREL);
    private static final List<BarrelMaterial> WOODEN_BARRELS = new ArrayList<BarrelMaterial>();

    ModTags() {
    }

    public static void createBlockTags(MKTagsProvider<Block> tags) {
        DirectTagAppender wateringCanTickable = tags.tag(EBlockTags.WATERING_CAN_TICKABLE);
        wateringCanTickable.add((Object[])new Block[]{Blocks.f_50440_, Blocks.f_50195_, Blocks.f_50700_, Blocks.f_50691_, Blocks.f_50073_, Blocks.f_50072_, Blocks.f_50128_, Blocks.f_50130_, Blocks.f_50685_, Blocks.f_50262_}).addTags(new TagKey[]{BlockTags.f_13104_, BlockTags.f_13077_, BlockTags.f_13074_});
        for (ResourceLocation path : ModCompatData.PAMS_CROPS) {
            wateringCanTickable.addOptional(path);
        }
        tags.tag(BlockTags.f_144280_).add((Object[])((Block[])WOODEN_BARRELS.stream().map(AbstractMaterial::getBlock).toArray(Block[]::new))).add((Object[])((Block[])DefaultMaterials.SIEVES.stream().filter(material -> material != DefaultMaterials.CRYSTALLIZED_SIEVE).map(AbstractMaterial::getBlock).toArray(Block[]::new))).add((Object[])((Block[])DefaultMaterials.WATER_CRUCIBLES.stream().map(AbstractMaterial::getBlock).toArray(Block[]::new))).add((Object[])new Block[]{DefaultMaterials.WARPED_CRUCIBLE.getBlock(), DefaultMaterials.CRIMSON_CRUCIBLE.getBlock(), DefaultMaterials.HELLBARK_CRUCIBLE.getBlock()}).add((Object[])((Block[])DefaultMaterials.COMPRESSED_SIEVES.stream().filter(material -> material != DefaultMaterials.CRYSTALLIZED_COMPRESSED_SIEVE).map(AbstractMaterial::getBlock).toArray(Block[]::new)));
        tags.tag(BlockTags.f_144282_).add(new Supplier[]{EBlocks.UNFIRED_PORCELAIN_CRUCIBLE, EBlocks.MECHANICAL_SIEVE, EBlocks.MECHANICAL_HAMMER}).add((Object[])new Block[]{DefaultMaterials.STONE_BARREL.getBlock(), DefaultMaterials.CRYSTALLIZED_BARREL.getBlock(), DefaultMaterials.CRYSTALLIZED_SIEVE.getBlock(), DefaultMaterials.PORCELAIN_CRUCIBLE.getBlock(), DefaultMaterials.CRYSTALLIZED_CRUCIBLE.getBlock()}).add((Object[])new Block[]{ECompressedBlocks.COMPRESSED_COBBLESTONE.getBlock(), ECompressedBlocks.COMPRESSED_DIORITE.getBlock(), ECompressedBlocks.COMPRESSED_GRANITE.getBlock(), ECompressedBlocks.COMPRESSED_ANDESITE.getBlock(), ECompressedBlocks.COMPRESSED_DEEPSLATE.getBlock(), ECompressedBlocks.COMPRESSED_COBBLED_DEEPSLATE.getBlock(), ECompressedBlocks.COMPRESSED_NETHERRACK.getBlock(), ECompressedBlocks.COMPRESSED_BLACKSTONE.getBlock(), ECompressedBlocks.COMPRESSED_END_STONE.getBlock()});
        tags.tag(BlockTags.f_144283_).add(new Supplier[]{EBlocks.DUST, EBlocks.CRUSHED_NETHERRACK, EBlocks.CRUSHED_END_STONE, EBlocks.CRUSHED_DEEPSLATE, EBlocks.CRUSHED_BLACKSTONE}).add((Object[])new Block[]{ECompressedBlocks.COMPRESSED_DIRT.getBlock(), ECompressedBlocks.COMPRESSED_GRAVEL.getBlock(), ECompressedBlocks.COMPRESSED_SAND.getBlock(), ECompressedBlocks.COMPRESSED_DUST.getBlock(), ECompressedBlocks.COMPRESSED_RED_SAND.getBlock(), ECompressedBlocks.COMPRESSED_CRUSHED_DEEPSLATE.getBlock(), ECompressedBlocks.COMPRESSED_CRUSHED_BLACKSTONE.getBlock(), ECompressedBlocks.COMPRESSED_CRUSHED_NETHERRACK.getBlock(), ECompressedBlocks.COMPRESSED_SOUL_SAND.getBlock(), ECompressedBlocks.COMPRESSED_CRUSHED_END_STONE.getBlock()});
        tags.tag(BlockTags.f_144281_).add(EBlocks.INFESTED_LEAVES).add((Object)ECompressedBlocks.COMPRESSED_MOSS_BLOCK.getBlock());
        tags.tag(BlockTags.f_13035_).add(EBlocks.INFESTED_LEAVES);
    }

    public static void createItemTags(MKTagsProvider<Item> tags) {
        tags.tag(EItemTags.HAMMERS).add(new Supplier[]{EItems.WOODEN_HAMMER, EItems.STONE_HAMMER, EItems.GOLDEN_HAMMER, EItems.IRON_HAMMER, EItems.DIAMOND_HAMMER, EItems.NETHERITE_HAMMER});
        tags.tag(EItemTags.COMPRESSED_HAMMERS).add(new Supplier[]{EItems.COMPRESSED_WOODEN_HAMMER, EItems.COMPRESSED_STONE_HAMMER, EItems.COMPRESSED_GOLDEN_HAMMER, EItems.COMPRESSED_IRON_HAMMER, EItems.COMPRESSED_DIAMOND_HAMMER, EItems.COMPRESSED_NETHERITE_HAMMER});
        tags.tag(EItemTags.CROOKS).add(new Supplier[]{EItems.CROOK, EItems.BONE_CROOK});
        tags.tag(EItemTags.SIEVE_MESHES).add(new Supplier[]{EItems.STRING_MESH, EItems.FLINT_MESH, EItems.IRON_MESH, EItems.GOLDEN_MESH, EItems.DIAMOND_MESH, EItems.NETHERITE_MESH});
        tags.tag(EItemTags.PEBBLES).add(new Supplier[]{EItems.STONE_PEBBLE, EItems.DIORITE_PEBBLE, EItems.GRANITE_PEBBLE, EItems.ANDESITE_PEBBLE, EItems.DEEPSLATE_PEBBLE, EItems.TUFF_PEBBLE, EItems.CALCITE_PEBBLE, EItems.BLACKSTONE_PEBBLE, EItems.BASALT_PEBBLE});
        tags.tag(EItemTags.ORE_CHUNKS).add((Object[])new Item[]{(Item)EItems.IRON_ORE_CHUNK.get(), (Item)EItems.COPPER_ORE_CHUNK.get(), (Item)EItems.GOLD_ORE_CHUNK.get(), (Item)EItems.ALUMINUM_ORE_CHUNK.get(), (Item)EItems.COBALT_ORE_CHUNK.get(), (Item)EItems.SILVER_ORE_CHUNK.get(), (Item)EItems.LEAD_ORE_CHUNK.get(), (Item)EItems.PLATINUM_ORE_CHUNK.get(), (Item)EItems.NICKEL_ORE_CHUNK.get(), (Item)EItems.URANIUM_ORE_CHUNK.get(), (Item)EItems.OSMIUM_ORE_CHUNK.get(), (Item)EItems.TIN_ORE_CHUNK.get(), (Item)EItems.ZINC_ORE_CHUNK.get(), (Item)EItems.IRIDIUM_ORE_CHUNK.get(), (Item)EItems.THORIUM_ORE_CHUNK.get(), (Item)EItems.MAGNESIUM_ORE_CHUNK.get(), (Item)EItems.LITHIUM_ORE_CHUNK.get(), (Item)EItems.BORON_ORE_CHUNK.get()});
        tags.tag(EItemTags.END_CAKE_MATERIAL).add((Object)Items.f_42545_);
        tags.tag(EItemTags.WOODEN_BARRELS).add((Object[])((Item[])WOODEN_BARRELS.stream().map(AbstractMaterial::getItem).toArray(Item[]::new)));
        tags.tag(EItemTags.STONE_BARRELS).add((Object[])new Item[]{DefaultMaterials.STONE_BARREL.getItem(), DefaultMaterials.CRYSTALLIZED_BARREL.getItem()});
        tags.tag(EItemTags.BARRELS).addTags(new TagKey[]{EItemTags.WOODEN_BARRELS, EItemTags.STONE_BARRELS});
        tags.tag(ECompressedBlocks.COMPRESSED_COBBLESTONE.getTag()).addOptional(new ResourceLocation("cyclic", "compressed_cobblestone"));
        for (CompressedBlockType variant : ECompressedBlocks.ALL_VARIANTS) {
            DirectTagAppender builder = tags.tag(variant.getTag()).add((Object)variant.getItem());
            if (variant.hasAtc()) {
                builder.addOptional(variant.getAtc());
            }
            if (!variant.hasCompressium()) continue;
            builder.addOptional(variant.getCompressium());
        }
        tags.tag(EItemTags.COMPRESSED_SANDS).addTags(new TagKey[]{ECompressedBlocks.COMPRESSED_SAND.getTag(), ECompressedBlocks.COMPRESSED_RED_SAND.getTag()});
    }

    public static void createStructureSetTags(MKTagsProvider<StructureSet> tags) {
        tags.tag(EStructureSetTags.OVERWORLD_VOID_STRUCTURES);
        tags.tag(EStructureSetTags.THE_NETHER_VOID_STRUCTURES).m_255204_(BuiltinStructureSets.f_209833_);
        tags.tag(EStructureSetTags.THE_END_VOID_STRUCTURES).m_255204_(BuiltinStructureSets.f_209835_);
    }

    public static void createWorldPresetTags(MKTagsProvider<WorldPreset> tags) {
        tags.tag(WorldPresetTags.f_216053_).m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256729_, (ResourceLocation)new ResourceLocation("exdeorum", "void_world")));
    }

    public static void createFluidTags(MKTagsProvider<Fluid> tags) {
        tags.tag(FluidTags.f_13131_).add((Object[])new Fluid[]{(Fluid)EFluids.WITCH_WATER.get(), (Fluid)EFluids.WITCH_WATER_FLOWING.get()});
    }

    static {
        for (BarrelMaterial material : DefaultMaterials.BARRELS) {
            if (STONE_MATERIALS.contains(material)) continue;
            WOODEN_BARRELS.add(material);
        }
    }
}

