/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thedarkcolour.exdeorum.data.Advancements;
import thedarkcolour.exdeorum.data.BlockModels;
import thedarkcolour.exdeorum.data.English;
import thedarkcolour.exdeorum.data.ItemModels;
import thedarkcolour.exdeorum.data.LootTables;
import thedarkcolour.exdeorum.data.ModCompatData;
import thedarkcolour.exdeorum.data.ModTags;
import thedarkcolour.exdeorum.data.Sounds;
import thedarkcolour.exdeorum.data.recipe.Recipes;
import thedarkcolour.modkit.data.DataHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Data {
    @SubscribeEvent
    public static void generateData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        DataHelper dataHelper = new DataHelper("exdeorum", event);
        dataHelper.createEnglish(true, English::addTranslations);
        dataHelper.createBlockModels(BlockModels::addBlockModels);
        dataHelper.createItemModels(true, true, false, ItemModels::addItemModels);
        dataHelper.createRecipes(Recipes::addRecipes);
        dataHelper.createTags(Registries.f_256747_, ModTags::createBlockTags);
        dataHelper.createTags(Registries.f_256913_, ModTags::createItemTags);
        dataHelper.createTags(Registries.f_256808_, ModTags::createFluidTags);
        dataHelper.createTags(Registries.f_256998_, ModTags::createStructureSetTags);
        dataHelper.createTags(Registries.f_256729_, ModTags::createWorldPresetTags);
        gen.addProvider(true, (DataProvider)new LootTables(output));
        gen.addProvider(true, (DataProvider)new Advancements(output, lookup, helper));
        gen.addProvider(true, (DataProvider)new Sounds(output, helper));
    }

    static {
        if (DatagenModLoader.isRunningDataGen()) {
            ModCompatData.registerModData();
        }
    }
}

