/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.HashMap;
import java.util.Map;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import thedarkcolour.exdeorum.client.RenderFace;
import thedarkcolour.exdeorum.client.ter.SieveRenderer;

public class RenderUtil {
    private static final VarHandle COMPOSITE_MODEL_CHILDREN;
    private static final Map<Block, RenderFace> TOP_FACES;
    public static final RenderStateShard.ShaderStateShard RENDER_TYPE_TINTED_CUTOUT_MIPPED_SHADER;
    public static final RenderType TINTED_CUTOUT_MIPPED;
    public static TextureAtlas blockAtlas;
    public static ShaderInstance renderTypeTintedCutoutMippedShader;
    public static final IrisAccess IRIS_ACCESS;

    public static void reload() {
        RenderUtil.invalidateCaches();
        blockAtlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
    }

    public static void invalidateCaches() {
        SieveRenderer.MESH_TEXTURES.clear();
        TOP_FACES.clear();
        blockAtlas = null;
    }

    public static RenderFace getTopFaceOrDefault(Block block, Block defaultBlock) {
        RenderFace face = RenderUtil.getTopFace(block);
        if (face.isMissingTexture()) {
            return RenderUtil.getTopFace(defaultBlock);
        }
        return face;
    }

    public static RenderFace getTopFace(Block block) {
        Record face;
        if (TOP_FACES.containsKey(block)) {
            return TOP_FACES.get(block);
        }
        LegacyRandomSource rand = new LegacyRandomSource((long)block.hashCode());
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(block.m_49966_());
        if (model instanceof CompositeModel.Baked) {
            CompositeModel.Baked composite = (CompositeModel.Baked)model;
            ImmutableMap children = COMPOSITE_MODEL_CHILDREN.get(composite);
            RenderFace.CompositeLayer[] layers = new RenderFace.CompositeLayer[children.size()];
            int i = 0;
            for (BakedModel childModel : children.values()) {
                RenderFace.Single singleFace = RenderUtil.getFaceFromModel(block, (RandomSource)rand, childModel);
                layers[i++] = new RenderFace.CompositeLayer(singleFace.renderType(), singleFace.sprite());
            }
            face = new RenderFace.Composite(layers);
        } else {
            face = RenderUtil.getFaceFromModel(block, (RandomSource)rand, model);
        }
        TOP_FACES.put(block, (RenderFace)((Object)face));
        return face;
    }

    private static RenderFace.Single getFaceFromModel(Block block, RandomSource rand, BakedModel model) {
        TextureAtlasSprite texture = RenderUtil.getTopTexture(block, model);
        ChunkRenderTypeSet blockTypes = model.getRenderTypes(block.m_49966_(), rand, ModelData.EMPTY);
        for (RenderType bufferLayer : RenderType.m_110506_()) {
            if (!blockTypes.contains(bufferLayer)) continue;
            return new RenderFace.Single(bufferLayer, texture);
        }
        throw new IllegalStateException("No render type found for block " + block);
    }

    private static TextureAtlasSprite getTopTexture(Block block, BakedModel model) {
        ResourceLocation registryName = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        TextureAtlasSprite sprite = blockAtlas.m_118316_(registryName.m_246208_("block/"));
        if (RenderUtil.isMissingTexture(sprite)) {
            sprite = blockAtlas.m_118316_(new ResourceLocation(registryName.m_135827_(), "block/" + registryName.m_135815_() + "_top"));
        }
        if (RenderUtil.isMissingTexture(sprite)) {
            sprite = model.getParticleIcon(ModelData.EMPTY);
        }
        return sprite;
    }

    public static boolean isMissingTexture(TextureAtlasSprite sprite) {
        return sprite.m_245424_().m_246162_() == MissingTextureAtlasSprite.m_118071_();
    }

    public static void renderFlatFluidSprite(MultiBufferSource buffers, PoseStack stack, Level level, BlockPos pos, float y, float edge, int light, int r, int g, int b, Fluid fluid) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidState state = fluid.m_76145_();
        VertexConsumer builder = buffers.m_6299_(Sheets.m_110792_());
        RenderUtil.renderFlatSprite(builder, stack, y, r, g, b, blockAtlas.m_118316_(extensions.getStillTexture(state, (BlockAndTintGetter)level, pos)), light, edge);
    }

    public static void renderFluidCuboid(MultiBufferSource buffers, PoseStack stack, Level level, BlockPos pos, float minY, float maxY, float edge, int light, int r, int g, int b, Fluid fluid) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidState state = fluid.m_76145_();
        VertexConsumer builder = buffers.m_6299_(Sheets.m_110792_());
        Matrix4f pose = stack.m_85850_().m_252922_();
        Matrix3f poseNormal = stack.m_85850_().m_252943_();
        TextureAtlasSprite sprite = blockAtlas.m_118316_(extensions.getStillTexture(state, (BlockAndTintGetter)level, pos));
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float edgeMin = edge / 16.0f;
        float edgeMax = 1.0f - edge / 16.0f;
        Vector3f normal = poseNormal.transform(new Vector3f(0.0f, 1.0f, 0.0f));
        builder.m_252986_(pose, edgeMin, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(0.0f, -1.0f, 0.0f));
        builder.m_252986_(pose, edgeMin, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        float f = sprite.m_118412_() - sprite.m_118411_();
        vMax = sprite.m_118411_() + f * (maxY - minY);
        normal = poseNormal.transform(new Vector3f(0.0f, 0.0f, 1.0f));
        builder.m_252986_(pose, edgeMax, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(0.0f, 0.0f, -1.0f));
        builder.m_252986_(pose, edgeMin, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(1.0f, 0.0f, 0.0f));
        builder.m_252986_(pose, edgeMax, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(-1.0f, 0.0f, 0.0f));
        builder.m_252986_(pose, edgeMin, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
    }

    public static void renderFlatSpriteLerp(VertexConsumer builder, PoseStack stack, float percentage, int r, int g, int b, TextureAtlasSprite sprite, int light, float edge, float yMin, float yMax) {
        float y = Mth.m_14179_((float)percentage, (float)yMin, (float)yMax) / 16.0f;
        RenderUtil.renderFlatSprite(builder, stack, y, r, g, b, sprite, light, edge);
    }

    public static void renderFlatSprite(VertexConsumer builder, PoseStack stack, float y, int r, int g, int b, TextureAtlasSprite sprite, int light, float edge) {
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f normal = stack.m_85850_().m_252943_().transform(new Vector3f(0.0f, 1.0f, 0.0f));
        float edgeMin = edge / 16.0f;
        float edgeMax = (16.0f - edge) / 16.0f;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        builder.m_252986_(pose, edgeMin, y, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, y, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, y, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, y, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_85969_(light).m_5601_(normal.x, normal.y, normal.z).m_5752_();
    }

    public static void renderCuboid(VertexConsumer builder, PoseStack stack, float minY, float maxY, int r, int g, int b, TextureAtlasSprite sprite, int light, float edge) {
        Matrix4f pose = stack.m_85850_().m_252922_();
        Matrix3f poseNormal = stack.m_85850_().m_252943_();
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float edgeMin = edge / 16.0f;
        float edgeMax = 1.0f - edge / 16.0f;
        int lightU = light & 0xFFFF;
        int lightV = light >> 16 & 0xFFFF;
        Vector3f normal = poseNormal.transform(new Vector3f(0.0f, 1.0f, 0.0f));
        builder.m_252986_(pose, edgeMin, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(0.0f, -1.0f, 0.0f));
        builder.m_252986_(pose, edgeMin, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        float f = sprite.m_118412_() - sprite.m_118411_();
        vMax = sprite.m_118411_() + f * (maxY - minY);
        normal = poseNormal.transform(new Vector3f(0.0f, 0.0f, -1.0f));
        builder.m_252986_(pose, edgeMax, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(0.0f, 0.0f, -1.0f));
        builder.m_252986_(pose, edgeMin, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(1.0f, 0.0f, 0.0f));
        builder.m_252986_(pose, edgeMax, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMax, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        normal = poseNormal.transform(new Vector3f(-1.0f, 0.0f, 0.0f));
        builder.m_252986_(pose, edgeMin, maxY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, maxY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMin).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMin).m_6122_(r, g, b, 255).m_7421_(uMin, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        builder.m_252986_(pose, edgeMin, minY, edgeMax).m_6122_(r, g, b, 255).m_7421_(uMax, vMax).m_7122_(0, 10).m_7120_(lightU, lightV).m_5601_(normal.x, normal.y, normal.z).m_5752_();
    }

    public static Color getRainbowColor(long time, float partialTicks) {
        return Color.getHSBColor((180.0f * Mth.m_14031_((float)(((float)time + partialTicks) / 30.0f)) - 180.0f) / 360.0f, 0.5f, 0.8f);
    }

    public static ShaderInstance getRenderTypeTintedCutoutMippedShader() {
        return renderTypeTintedCutoutMippedShader;
    }

    public static int getFluidColor(Fluid fluid, Level level, BlockPos pos) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.m_76145_(), (BlockAndTintGetter)level, pos);
    }

    static {
        IrisAccess irisAccess;
        TOP_FACES = new HashMap<Block, RenderFace>();
        RENDER_TYPE_TINTED_CUTOUT_MIPPED_SHADER = new RenderStateShard.ShaderStateShard(RenderUtil::getRenderTypeTintedCutoutMippedShader);
        TINTED_CUTOUT_MIPPED = RenderType.m_173215_((String)"exdeorum:tinted_cutout_mipped", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)131072, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(RenderStateShard.f_110152_).m_173292_(RENDER_TYPE_TINTED_CUTOUT_MIPPED_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110691_(true));
        try {
            Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            irisAccess = () -> ((IrisApi)IrisApi.getInstance()).isShaderPackInUse();
        }
        catch (ClassNotFoundException e) {
            irisAccess = () -> false;
        }
        IRIS_ACCESS = irisAccess;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            COMPOSITE_MODEL_CHILDREN = MethodHandles.privateLookupIn(CompositeModel.Baked.class, lookup).findVarHandle(CompositeModel.Baked.class, "children", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface IrisAccess {
        public boolean areShadersEnabled();
    }
}

