/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.VMBridge;
import dev.latvian.mods.rhino.WrappedExecutable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class MemberBox {
    transient Class<?>[] argTypes;
    transient Object delegateTo;
    transient boolean vararg;
    public transient Executable executable;
    public transient WrappedExecutable wrappedExecutable;

    private static Method searchAccessibleMethod(Method method, Class<?>[] params) {
        Class<?> c;
        int modifiers = method.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isPublic((c = method.getDeclaringClass()).getModifiers())) {
            String name = method.getName();
            Class<?>[] intfs = c.getInterfaces();
            int N = intfs.length;
            for (int i = 0; i != N; ++i) {
                Class<?> intf = intfs[i];
                if (!Modifier.isPublic(intf.getModifiers())) continue;
                try {
                    return intf.getMethod(name, params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((c = c.getSuperclass()) != null) {
                if (!Modifier.isPublic(c.getModifiers())) continue;
                try {
                    Method m = c.getMethod(name, params);
                    int mModifiers = m.getModifiers();
                    if (!Modifier.isPublic(mModifiers) || Modifier.isStatic(mModifiers)) continue;
                    return m;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }

    MemberBox(Executable executable) {
        this.executable = executable;
        this.argTypes = executable.getParameterTypes();
        this.vararg = executable.isVarArgs();
    }

    MemberBox(WrappedExecutable wrappedExecutable) {
        Executable executable = wrappedExecutable.unwrap();
        if (executable != null) {
            this.executable = executable;
            this.argTypes = executable.getParameterTypes();
            this.vararg = executable.isVarArgs();
        } else {
            this.wrappedExecutable = wrappedExecutable;
            this.vararg = false;
        }
    }

    Constructor<?> ctor() {
        return (Constructor)this.executable;
    }

    Member member() {
        return this.executable;
    }

    boolean isMethod() {
        return this.executable instanceof Method;
    }

    boolean isCtor() {
        return this.executable instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.executable.getModifiers());
    }

    boolean isPublic() {
        return Modifier.isPublic(this.executable.getModifiers());
    }

    String getName() {
        return this.wrappedExecutable != null ? this.wrappedExecutable.toString() : this.executable.getName();
    }

    Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    Class<?> getReturnType() {
        return this.wrappedExecutable != null ? this.wrappedExecutable.getReturnType() : ((Method)this.executable).getReturnType();
    }

    String toJavaDeclaration() {
        StringBuilder sb = new StringBuilder();
        if (this.isMethod()) {
            sb.append(this.getReturnType());
            sb.append(' ');
            sb.append(this.getName());
        } else {
            String name = this.getDeclaringClass().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0) {
                name = name.substring(lastDot + 1);
            }
            sb.append(name);
        }
        sb.append(JavaMembers.liveConnectSignature(this.argTypes));
        return sb.toString();
    }

    public String toString() {
        return this.executable.toString();
    }

    Object invoke(Object target, Object[] args, Context cx, Scriptable scope) {
        if (this.wrappedExecutable != null) {
            try {
                return this.wrappedExecutable.invoke(cx, scope, target, args);
            }
            catch (Exception ex) {
                throw Context.throwAsScriptRuntimeEx(ex, cx);
            }
        }
        Method method = (Method)this.executable;
        try {
            try {
                return method.invoke(target, args);
            }
            catch (IllegalAccessException ex) {
                Method accessible = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (accessible != null) {
                    this.executable = accessible;
                    method = accessible;
                } else if (!VMBridge.tryToMakeAccessible(target, method)) {
                    throw Context.throwAsScriptRuntimeEx(ex, cx);
                }
                return method.invoke(target, args);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite;
            while ((e = e.getTargetException()) instanceof InvocationTargetException) {
            }
            throw Context.throwAsScriptRuntimeEx(e, cx);
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex, cx);
        }
    }

    Object newInstance(Object[] args, Context cx, Scriptable scope) {
        if (this.wrappedExecutable != null) {
            try {
                return this.wrappedExecutable.construct(cx, scope, args);
            }
            catch (Exception ex) {
                throw Context.throwAsScriptRuntimeEx(ex, cx);
            }
        }
        Constructor<?> ctor = this.ctor();
        try {
            try {
                return ctor.newInstance(args);
            }
            catch (IllegalAccessException ex) {
                if (!VMBridge.tryToMakeAccessible(null, ctor)) {
                    throw Context.throwAsScriptRuntimeEx(ex, cx);
                }
                return ctor.newInstance(args);
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex, cx);
        }
    }
}

