/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.lootr;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import snownee.jade.addon.lootr.LootrPlugin;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum LootrInventoryProvider implements IServerExtensionProvider<Object, ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return LootrPlugin.INVENTORY;
    }

    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, ItemView::new, null);
    }

    public List<ViewGroup<ItemStack>> getGroups(ServerPlayer player, ServerLevel level, Object target, boolean showDetails) {
        LootrChestMinecartEntity cart;
        if (target instanceof ILootBlockEntity) {
            ILootBlockEntity tile = (ILootBlockEntity)target;
            if (tile.getOpeners().contains(player.m_20148_())) {
                UUID id = tile.getTileId();
                SpecialChestInventory inv = DataStorage.getInventory((Level)level, (UUID)id, (BlockPos)tile.getPosition(), (ServerPlayer)player, (RandomizableContainerBlockEntity)((RandomizableContainerBlockEntity)tile), (arg_0, arg_1, arg_2, arg_3) -> ((ILootBlockEntity)tile).unpackLootTable(arg_0, arg_1, arg_2, arg_3));
                if (inv != null) {
                    return List.of(ItemView.fromContainer((Container)inv, (int)54, (int)0));
                }
            }
        } else if (target instanceof LootrChestMinecartEntity && (cart = (LootrChestMinecartEntity)target).getOpeners().contains(player.m_20148_())) {
            SpecialChestInventory inv = DataStorage.getInventory((Level)level, (LootrChestMinecartEntity)cart, (ServerPlayer)player, (arg_0, arg_1, arg_2, arg_3) -> ((LootrChestMinecartEntity)cart).addLoot(arg_0, arg_1, arg_2, arg_3));
            if (inv != null) {
                return List.of(ItemView.fromContainer((Container)inv, (int)54, (int)0));
            }
        }
        return ItemStorageProvider.INSTANCE.getGroups(player, level, target, showDetails);
    }
}

