/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElementHelper;

public enum BlazeBurnerProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag compound = accessor.getServerData();
        BlazeBurnerBlockEntity.FuelType activeFuel = BlazeBurnerBlockEntity.FuelType.NONE;
        boolean isCreative = compound.m_128471_("isCreative");
        if (isCreative) {
            BlazeBurnerBlock.HeatLevel heatLevel = BasinBlockEntity.getHeatLevelOf((BlockState)accessor.getBlockState());
            if (heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING) {
                activeFuel = BlazeBurnerBlockEntity.FuelType.SPECIAL;
            } else if (heatLevel != BlazeBurnerBlock.HeatLevel.NONE) {
                activeFuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
            }
        } else {
            activeFuel = BlazeBurnerBlockEntity.FuelType.values()[compound.m_128451_("fuelLevel")];
        }
        if (activeFuel == BlazeBurnerBlockEntity.FuelType.NONE) {
            return;
        }
        ItemStack item = new ItemStack((ItemLike)(activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL ? Items.f_42782_ : Items.f_42781_));
        tooltip.add(IElementHelper.get().smallItem(item));
        if (isCreative) {
            tooltip.append((Component)IThemeHelper.get().info((Object)Component.m_237115_((String)"jade.infinity")));
        } else {
            tooltip.append((Component)IThemeHelper.get().seconds(compound.m_128451_("burnTimeRemaining")));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlazeBurnerBlockEntity burner = (BlazeBurnerBlockEntity)accessor.getBlockEntity();
        if (burner.isCreative()) {
            data.m_128379_("isCreative", true);
        } else if (burner.getActiveFuel() != BlazeBurnerBlockEntity.FuelType.NONE) {
            data.m_128405_("fuelLevel", burner.getActiveFuel().ordinal());
            data.m_128405_("burnTimeRemaining", burner.getRemainingBurnTime());
        }
    }

    public ResourceLocation getUid() {
        return CreatePlugin.BLAZE_BURNER;
    }
}

