/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStoreRegistryAccess;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.jetbrains.annotations.NotNull;

public class LootModifierInjectAbilityTotem
extends LootModifier {
    public static final Supplier<Codec<LootModifierInjectAbilityTotem>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootModifierInjectAbilityTotem.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.list((Codec)Codec.STRING).fieldOf("loot_tables").forGetter(LootModifierInjectAbilityTotem::getLootTables)).apply((Applicative)inst, LootModifierInjectAbilityTotem::new)));
    private final List<String> lootTables;

    public LootModifierInjectAbilityTotem(LootItemCondition[] conditionsIn, List<String> lootTables) {
        super(conditionsIn);
        this.lootTables = lootTables;
    }

    public List<String> getLootTables() {
        return this.lootTables;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.getLootTables().contains(context.getQueriedLootTableId().toString())) {
            try {
                List<IAbilityType> abilityTypes = AbilityHelpers.getAbilityTypesLoot(AbilityHelpers.getRegistry(context.m_78952_().m_9598_()));
                AbilityHelpers.getRandomRarity(abilityTypes, context.m_230907_()).ifPresent(rarity -> {
                    IAbilityType abilityType = AbilityHelpers.getRandomAbility(abilityTypes, context.m_230907_(), rarity).get();
                    ItemStack stack = new ItemStack((ItemLike)RegistryEntries.ITEM_ABILITY_TOTEM);
                    stack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(mutableAbilityStore -> {
                        ((IMutableAbilityStoreRegistryAccess)mutableAbilityStore).setRegistryAccess(context.m_78952_().m_9598_());
                        mutableAbilityStore.addAbility(new Ability(abilityType, 1), true);
                        generatedLoot.add((Object)stack);
                    });
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

