/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStoreRegistryAccess;
import org.cyclops.everlastingabilities.api.capability.ItemStackMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;

public abstract class ItemGuiAbilityContainer
extends ItemGui {
    protected ItemGuiAbilityContainer(Item.Properties properties) {
        super(properties);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerAbilityContainer.class;
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).m_41786_(), ContainerAbilityContainer::new);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(itemStack, worldIn, tooltip, flagIn);
        itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(abilityStore -> {
            if (worldIn != null) {
                ((IMutableAbilityStoreRegistryAccess)abilityStore).setRegistryAccess(worldIn.m_9598_());
            }
            ArrayList<Ability> abilities = new ArrayList<Ability>(abilityStore.getAbilities());
            Collections.sort(abilities);
            boolean empty = true;
            for (Ability ability : abilities) {
                empty = false;
                tooltip.add((Component)Component.m_237115_((String)ability.getAbilityType().getTranslationKey()).m_130946_(" " + ability.getLevel()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW))));
            }
            if (empty) {
                tooltip.add((Component)Component.m_237115_((String)"general.everlastingabilities.empty").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131155_(Boolean.valueOf(true))));
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new DefaultCapabilityProvider(() -> MutableAbilityStoreConfig.CAPABILITY, (Object)new ItemStackMutableAbilityStore(stack));
    }

    public abstract boolean canMoveFromPlayer();

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.m_41720_() != newStack.m_41720_();
    }
}

