/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.common.block.entity.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.common.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.PressRecipeManager;
import cofh.thermal.expansion.common.inventory.machine.MachinePressMenu;
import cofh.thermal.expansion.init.registries.TExpBlockEntities;
import cofh.thermal.lib.common.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.references.ThermalTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class MachinePressBlockEntity
extends MachineBlockEntity {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PressRecipeManager.instance().validInput(item));
    protected ItemStorageCoFH dieSlot = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && PressRecipeManager.instance().validDie(item));
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(4000);

    public MachinePressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TExpBlockEntities.MACHINE_PRESS_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.dieSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return PressRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = PressRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        List recipeOutputFluids = this.curRecipe.getOutputFluids((IMachineInventory)this);
        this.renderFluid = recipeOutputFluids.isEmpty() ? FluidStack.EMPTY : new FluidStack((FluidStack)recipeOutputFluids.get(0), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    protected void resolveInputs() {
        this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        if (this.itemInputCounts.size() > 1 && !this.dieSlot.getItemStack().m_204117_(ThermalTags.Items.MACHINE_DIES)) {
            this.dieSlot.modify(-((Integer)this.itemInputCounts.get(1)).intValue());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachinePressMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

