/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.recipe;

import com.glodblock.github.extendedae.recipe.CircuitCutterRecipe;
import com.glodblock.github.extendedae.recipe.util.IngredientStack;
import com.glodblock.github.extendedae.recipe.util.MachineRecipe;
import com.glodblock.github.extendedae.recipe.util.MachineResult;
import com.glodblock.github.extendedae.recipe.util.StackJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CircuitCutterRecipeSerializer
implements MachineRecipe<CircuitCutterRecipe> {
    public static final CircuitCutterRecipeSerializer INSTANCE = new CircuitCutterRecipeSerializer();
    public static final MachineResult.Type<CircuitCutterRecipe> RESULT = MachineResult.Type.type(INSTANCE);

    private CircuitCutterRecipeSerializer() {
    }

    @Override
    public void toJson(JsonObject json, CircuitCutterRecipe recipe) {
        json.add("item_input", recipe.input.toJson());
        if (!recipe.fluid.isEmpty()) {
            json.add("fluid_input", recipe.fluid.toJson());
        }
        json.add("output", (JsonElement)StackJson.toJson(recipe.output));
    }

    @NotNull
    public CircuitCutterRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        IngredientStack.Item input = IngredientStack.ofItem(json.getAsJsonObject("item_input"));
        IngredientStack.Fluid fluid = IngredientStack.Fluid.EMPTY;
        if (json.has("fluid_input")) {
            fluid = IngredientStack.ofFluid(json.getAsJsonObject("fluid_input"));
        }
        ItemStack output = StackJson.fromJson(json.get("output"));
        return new CircuitCutterRecipe(id, output, input, fluid);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull CircuitCutterRecipe recipe) {
        buffer.m_130055_(recipe.output);
        recipe.input.to(buffer);
        recipe.fluid.to(buffer);
    }

    @Nullable
    public CircuitCutterRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buff) {
        ItemStack output = buff.m_130267_();
        IngredientStack.Item input = IngredientStack.ofItem(buff);
        IngredientStack.Fluid fluid = IngredientStack.ofFluid(buff);
        return new CircuitCutterRecipe(id, output, input, fluid);
    }
}

