/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.common.me.modlist.ModPriorityList;
import com.glodblock.github.extendedae.common.parts.base.PartSpecialStorageBus;
import com.glodblock.github.extendedae.container.ContainerModStorageBus;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class PartModStorageBus
extends PartSpecialStorageBus {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("expatternprovider", "part/mod_storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_has_channel")});
    private String modid = "";

    public PartModStorageBus(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.modid = data.m_128461_("modid");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128359_("modid", this.modid);
    }

    @Override
    public MenuType<?> getMenuType() {
        return ContainerModStorageBus.TYPE;
    }

    protected final int getUpgradeSlots() {
        return 2;
    }

    public void setModNameFilter(String exp) {
        if (!exp.equals(this.modid)) {
            this.modid = exp;
            this.filter = null;
            this.forceUpdate();
        }
    }

    public String getModNameFilter() {
        return this.modid;
    }

    @Override
    protected IPartitionList createFilter() {
        if (this.filter == null) {
            this.filter = new ModPriorityList(this.modid);
        }
        return this.filter;
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        this.modid = input.m_128441_("mod_name_exp") ? input.m_128461_("mod_name_exp") : "";
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.m_128359_("mod_name_exp", this.modid);
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

