/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe;

import com.almostreliable.summoningrituals.Registration;
import com.almostreliable.summoningrituals.inventory.VanillaWrapper;
import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.recipe.component.IngredientStack;
import com.almostreliable.summoningrituals.recipe.component.RecipeOutputs;
import com.almostreliable.summoningrituals.recipe.component.RecipeSacrifices;
import com.almostreliable.summoningrituals.util.GameUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class AltarRecipe
implements Recipe<VanillaWrapper> {
    public static final Set<Ingredient> CATALYST_CACHE = new HashSet<Ingredient>();
    private final ResourceLocation id;
    private final Ingredient catalyst;
    private final RecipeOutputs outputs;
    private final NonNullList<IngredientStack> inputs;
    private final RecipeSacrifices sacrifices;
    private final int recipeTime;
    @Nullable
    private final BlockReference blockBelow;
    private final DAY_TIME dayTime;
    private final WEATHER weather;

    AltarRecipe(ResourceLocation id, Ingredient catalyst, RecipeOutputs outputs, NonNullList<IngredientStack> inputs, RecipeSacrifices sacrifices, int recipeTime, @Nullable BlockReference blockBelow, DAY_TIME dayTime, WEATHER weather) {
        this.id = id;
        this.outputs = outputs;
        this.inputs = inputs;
        this.catalyst = catalyst;
        this.sacrifices = sacrifices;
        this.recipeTime = recipeTime;
        this.blockBelow = blockBelow;
        this.dayTime = dayTime;
        this.weather = weather;
    }

    public boolean matches(VanillaWrapper inv, Level level) {
        if (inv.getCatalyst().m_41619_() || !this.catalyst.test(inv.getCatalyst())) {
            return false;
        }
        Ingredient[] matchedItems = new Ingredient[inv.m_6643_()];
        ArrayList<Ingredient> matchedIngredients = new ArrayList<Ingredient>();
        for (int slot = 0; slot < inv.getItems().size(); ++slot) {
            ItemStack stack = inv.getItems().get(slot);
            if (stack.m_41619_() || matchedItems[slot] != null) continue;
            for (IngredientStack input : this.inputs) {
                if (matchedIngredients.contains(input.ingredient()) || !input.ingredient().test(stack) || stack.m_41613_() < input.count()) continue;
                matchedItems[slot] = input.ingredient();
                matchedIngredients.add(input.ingredient());
            }
        }
        return matchedIngredients.size() == this.inputs.size();
    }

    public ItemStack assemble(VanillaWrapper inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.ALTAR_RECIPE.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)Registration.ALTAR_RECIPE.type().get();
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public RecipeOutputs getOutputs() {
        return this.outputs;
    }

    public NonNullList<IngredientStack> getInputs() {
        return this.inputs;
    }

    public RecipeSacrifices getSacrifices() {
        return this.sacrifices;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    @Nullable
    public BlockReference getBlockBelow() {
        return this.blockBelow;
    }

    public DAY_TIME getDayTime() {
        return this.dayTime;
    }

    public WEATHER getWeather() {
        return this.weather;
    }

    public static enum DAY_TIME {
        ANY,
        DAY,
        NIGHT;


        public boolean check(Level level, @Nullable ServerPlayer player) {
            boolean check;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ANY: {
                    boolean bl = true;
                    break;
                }
                case DAY: {
                    boolean bl = level.m_46461_();
                    break;
                }
                case NIGHT: {
                    boolean bl = check = level.m_46462_();
                }
            }
            if (!check) {
                GameUtils.sendPlayerMessage((Player)player, this.toString().toLowerCase(), ChatFormatting.YELLOW, new Object[0]);
            }
            return check;
        }
    }

    public static enum WEATHER {
        ANY,
        CLEAR,
        RAIN,
        THUNDER;


        public boolean check(Level level, @Nullable ServerPlayer player) {
            boolean check;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ANY: {
                    boolean bl = true;
                    break;
                }
                case CLEAR: {
                    boolean bl;
                    if (!level.m_46471_() && !level.m_46470_()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case RAIN: {
                    boolean bl = level.m_46471_();
                    break;
                }
                case THUNDER: {
                    boolean bl = check = level.m_46470_();
                }
            }
            if (!check) {
                GameUtils.sendPlayerMessage((Player)player, this.toString().toLowerCase(), ChatFormatting.YELLOW, new Object[0]);
            }
            return check;
        }
    }
}

