/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.jei;

import cy.jdkdigital.productivetrees.integrations.jei.ProductiveTreesJeiPlugin;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;

public class TreePollinationRecipeCategory
implements IRecipeCategory<TreePollinationRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public TreePollinationRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivetrees", "textures/gui/jei/tree_pollination.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 130, 60);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TreeRegistrator.POLLEN.get()));
    }

    public RecipeType<TreePollinationRecipe> getRecipeType() {
        return ProductiveTreesJeiPlugin.TREE_POLLINATION_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivetrees.tree_pollination");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TreePollinationRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 13, 27).addItemStacks(Arrays.stream(recipe.leafA.m_43908_()).map(TreeUtil::getSaplingFromLeaf).toList())).setSlotName("leafA");
        if (!ModList.get().isLoaded("emi")) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(Arrays.asList(recipe.leafA.m_43908_()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 56, 27).addItemStacks(Arrays.stream(recipe.leafB.m_43908_()).map(TreeUtil::getSaplingFromLeaf).toList())).setSlotName("leafB");
        if (!ModList.get().isLoaded("emi")) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(Arrays.asList(recipe.leafB.m_43908_()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 27).addItemStacks(List.of(recipe.result))).setSlotName("result");
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(TreeUtil.getLeafFromSapling(recipe.result));
    }
}

