/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FruitLeafPlacerDecorator
extends TreeDecorator {
    public static final Codec<FruitLeafPlacerDecorator> CODEC = RecordCodecBuilder.create(decoratorInstance -> decoratorInstance.group((App)Codec.FLOAT.fieldOf("density").orElse((Object)Float.valueOf(0.5f)).forGetter(FruitLeafPlacerDecorator::getDensity), (App)Codec.INT.fieldOf("max_fruits").orElse((Object)100).forGetter(FruitLeafPlacerDecorator::getMaxFruits), (App)BlockStateProvider.f_68747_.fieldOf("fruit_provider").forGetter(FruitLeafPlacerDecorator::getFruitProvider)).apply((Applicative)decoratorInstance, FruitLeafPlacerDecorator::new));
    private final float density;
    private final int maxFruits;
    public final BlockStateProvider fruitProvider;

    public FruitLeafPlacerDecorator(float density, int maxFruits, BlockStateProvider fruitProvider) {
        this.density = density;
        this.maxFruits = maxFruits;
        this.fruitProvider = fruitProvider;
    }

    public float getDensity() {
        return this.density;
    }

    public int getMaxFruits() {
        return this.maxFruits;
    }

    public BlockStateProvider getFruitProvider() {
        return this.fruitProvider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TreeRegistrator.FRUIT_LEAF_PLACER.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        if (context.m_226069_().isEmpty()) {
            return;
        }
        AtomicInteger count = new AtomicInteger();
        RandomSource rand = context.m_226067_();
        context.m_226069_().forEach(blockPos -> {
            if (count.get() < this.maxFruits && context.m_226059_(blockPos.m_7495_()) && rand.m_188501_() < this.density) {
                context.m_226061_(blockPos.m_7495_(), this.fruitProvider.m_213972_(rand, blockPos.m_7495_()));
                count.getAndIncrement();
            }
        });
    }
}

