/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import dev.ftb.mods.ftbquests.net.ClearDisplayCacheMessage;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.OpenQuestBookMessage;
import dev.ftb.mods.ftbquests.net.SyncEditorPermissionMessage;
import dev.ftb.mods.ftbquests.net.SyncQuestsMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsCommands {
    public static final SimpleCommandExceptionType NO_FILE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.ftbquests.command.error.no_file"));
    public static final DynamicCommandExceptionType NO_OBJECT = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.ftbquests.command.error.no_object", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType INVALID_ID = new DynamicCommandExceptionType(id -> Component.m_237110_((String)"commands.ftbquests.command.error.invalid_id", (Object[])new Object[]{id}));
    private static final SimpleCommandExceptionType NO_INVENTORY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.ftbquests.command.error.no_inventory"));
    private static final Set<UUID> warnedPlayers = new HashSet<UUID>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbquests").requires(s -> s.m_81377_() != null && s.m_81377_().m_129792_() || FTBQuestsCommands.hasEditorPermission(s))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"editing_mode").executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locked").executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(Commands.m_82127_((String)"delete_empty_reward_tables").executes(context -> FTBQuestsCommands.deleteEmptyRewardTables((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"change_progress").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, true, StringArgumentType.getString((CommandContext)ctx, (String)"quest_object"));
        })))).then(Commands.m_82127_((String)"complete").then(Commands.m_82129_((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, false, StringArgumentType.getString((CommandContext)ctx, (String)"quest_object"));
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export_reward_table_to_chest").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"reward_table", (ArgumentType)StringArgumentType.string()).executes(ctx -> FTBQuestsCommands.exportRewards((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"reward_table"), null))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> {
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.exportRewards((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"reward_table"), pos);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"import_reward_table_from_chest").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return FTBQuestsCommands.importRewards((CommandSourceStack)ctx.getSource(), name, null);
        })).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.importRewards((CommandSourceStack)ctx.getSource(), name, pos);
        }))))).then(Commands.m_82127_((String)"generate_chapter_with_all_items_in_game").executes(context -> FTBQuestsCommands.generateAllItemChapter((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(FTBQuestsCommands::hasEditorPermission)).executes(context -> FTBQuestsCommands.doReload((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"block_rewards").executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"open_book").executes(c -> FTBQuestsCommands.openQuest(((CommandSourceStack)c.getSource()).m_81375_(), null))).then(Commands.m_82129_((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(c -> FTBQuestsCommands.openQuest(((CommandSourceStack)c.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)c, (String)"quest_object")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_item_display_cache").requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.clearDisplayCache((CommandSourceStack)c.getSource()))));
    }

    private static boolean hasEditorPermission(CommandSourceStack stack) {
        return stack.m_6761_(2) || stack.m_230897_() && PermissionsHelper.hasEditorPermission(stack.m_230896_(), false);
    }

    private static QuestObjectBase getQuestObjectForString(String idStr) throws CommandSyntaxException {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null) {
            throw NO_FILE.create();
        }
        if (idStr.startsWith("#")) {
            String val = idStr.substring(1);
            for (QuestObjectBase qob : file.getAllObjects()) {
                if (!qob.hasTag(val)) continue;
                return qob;
            }
            throw NO_OBJECT.create((Object)idStr);
        }
        long id = QuestObjectBase.parseHexId(idStr).orElseThrow(() -> INVALID_ID.create((Object)idStr));
        QuestObjectBase qob = file.getBase(id);
        if (qob == null) {
            throw NO_OBJECT.create((Object)idStr);
        }
        return qob;
    }

    private static boolean playerCanSeeQuestObject(ServerPlayer player, QuestObject qo) {
        if (qo instanceof Chapter) {
            return true;
        }
        TeamData data = TeamData.get((Player)player);
        Quest quest = null;
        if (qo instanceof QuestLink) {
            QuestLink link = (QuestLink)qo;
            quest = link.getQuest().orElse(null);
        } else if (qo instanceof Task) {
            Task task = (Task)qo;
            quest = task.getQuest();
        } else if (qo instanceof Quest) {
            Quest q;
            quest = q = (Quest)qo;
        }
        return quest != null && (data.getCanEdit((Player)player) || !quest.hideDetailsUntilStartable() || data.canStartTasks(quest));
    }

    private static int openQuest(ServerPlayer player, String qobId) throws CommandSyntaxException {
        Quest quest;
        if (qobId == null) {
            new OpenQuestBookMessage(0L).sendTo(player);
            return 1;
        }
        QuestObjectBase questObjectBase = FTBQuestsCommands.getQuestObjectForString(qobId);
        if (questObjectBase instanceof Quest && FTBQuestsCommands.playerCanSeeQuestObject(player, quest = (Quest)questObjectBase)) {
            new OpenQuestBookMessage(quest.id).sendTo(player);
            return 1;
        }
        return 0;
    }

    private static int exportRewards(CommandSourceStack source, String idStr, @Nullable BlockPos pos) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        QuestObjectBase questObjectBase = FTBQuestsCommands.getQuestObjectForString(idStr);
        if (!(questObjectBase instanceof RewardTable)) {
            throw NO_OBJECT.create((Object)idStr);
        }
        RewardTable table = (RewardTable)questObjectBase;
        pos = Objects.requireNonNullElse(pos, BlockPos.m_274446_((Position)player.m_19907_(10.0, 1.0f, false).m_82450_()));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof BaseContainerBlockEntity)) {
            throw NO_INVENTORY.create();
        }
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
        container.m_6211_();
        int slot = 0;
        for (WeightedReward wr : table.getWeightedRewards()) {
            if (slot >= container.m_6643_()) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.ftbquests.command.feedback.table_too_many_items", (Object[])new Object[]{table.getTitle()}));
                return 0;
            }
            Reward reward = wr.getReward();
            if (!(reward instanceof ItemReward)) continue;
            ItemReward itemReward = (ItemReward)reward;
            container.m_6836_(slot++, itemReward.getItem());
        }
        source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.command.feedback.table_exported", (Object[])new Object[]{table.getTitle(), table.getWeightedRewards().size()}), false);
        return 1;
    }

    private static int importRewards(CommandSourceStack source, String name, BlockPos pos) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ServerLevel level = source.m_81372_();
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (pos == null) {
            pos = BlockPos.m_274446_((Position)player.m_19907_(10.0, 1.0f, false).m_82450_());
        }
        RewardTable table = new RewardTable(file.newID(), file);
        table.setRawTitle(name);
        table.setRawIcon(Items.f_42009_.m_7968_());
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof BaseContainerBlockEntity)) {
            throw NO_INVENTORY.create();
        }
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)be;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            table.addReward(table.makeWeightedItemReward(stack, 1.0f));
        }
        file.addRewardTable(table);
        new CreateObjectResponseMessage(table, null).sendToAll(level.m_7654_());
        source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.command.feedback.table_imported", (Object[])new Object[]{name, table.getWeightedRewards().size()}), false);
        return 1;
    }

    private static int editingMode(CommandSourceStack source, ServerPlayer player, @Nullable Boolean canEdit) {
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        if (canEdit == null) {
            canEdit = !data.getCanEdit((Player)player);
        }
        data.setCanEdit((Player)player, canEdit);
        if (canEdit.booleanValue()) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.editing_mode.enabled", (Object[])new Object[]{player.m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.editing_mode.disabled", (Object[])new Object[]{player.m_5446_()}), true);
        }
        return 1;
    }

    private static int locked(CommandSourceStack source, ServerPlayer player, @Nullable Boolean locked) {
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        if (locked == null) {
            locked = !data.isLocked();
        }
        data.setLocked(locked);
        if (locked.booleanValue()) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.locked.enabled", (Object[])new Object[]{player.m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.locked.disabled", (Object[])new Object[]{player.m_5446_()}), true);
        }
        return 1;
    }

    private static int changeProgress(CommandSourceStack source, Collection<ServerPlayer> players, boolean reset, String idStr) throws CommandSyntaxException {
        QuestObjectBase questObject = FTBQuestsCommands.getQuestObjectForString(idStr);
        for (ServerPlayer player : players) {
            ProgressChange progressChange = new ProgressChange(ServerQuestFile.INSTANCE, questObject, player.m_20148_()).setReset(reset);
            questObject.forceProgress(ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player), progressChange);
        }
        source.m_288197_(() -> Component.m_237115_((String)"commands.ftbquests.change_progress.text"), false);
        return 1;
    }

    private static int deleteEmptyRewardTables(CommandSourceStack source) {
        int removed = ServerQuestFile.INSTANCE.removeEmptyRewardTables(source);
        source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.command.delete_empty_reward_tables.text", (Object[])new Object[]{removed}), false);
        return 1;
    }

    private static int generateAllItemChapter(CommandSourceStack source) {
        if (!CreativeModeTabs.m_258007_().m_257905_()) {
            CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)true, (HolderLookup.Provider)source.m_81372_().m_9598_());
        }
        Collection allItems = CreativeModeTabs.m_258007_().m_261235_();
        long newId = ServerQuestFile.INSTANCE.newID();
        Chapter chapter = new Chapter(newId, ServerQuestFile.INSTANCE, ServerQuestFile.INSTANCE.getDefaultChapterGroup());
        chapter.onCreated();
        chapter.setRawTitle("Generated chapter of all items in search creative tab [" + allItems.size() + "]");
        chapter.setRawIcon(new ItemStack((ItemLike)Items.f_42522_));
        chapter.setDefaultQuestShape("rsquare");
        new CreateObjectResponseMessage(chapter, null).sendToAll(source.m_81377_());
        List<ItemStack> list = allItems.stream().filter(stack -> !stack.m_41619_() && RegistrarManager.getId((Object)stack.m_41720_(), (ResourceKey)Registries.f_256913_) != null).sorted(Comparator.comparing(a -> RegistrarManager.getId((Object)a.m_41720_(), (ResourceKey)Registries.f_256913_))).toList();
        FTBQuests.LOGGER.info("Found {} items in total, chapter ID: {}", (Object)allItems.size(), (Object)chapter);
        if (list.isEmpty()) {
            return 0;
        }
        int col = 0;
        int row = 0;
        String modid = RegistrarManager.getId((Object)list.get(0).m_41720_(), (ResourceKey)Registries.f_256913_).m_135827_();
        for (ItemStack stack2 : list) {
            ResourceLocation id = RegistrarManager.getId((Object)stack2.m_41720_(), (ResourceKey)Registries.f_256913_);
            if (!modid.equals(id.m_135827_())) {
                modid = id.m_135827_();
                col = 0;
                row += 2;
            } else if (col >= 40) {
                col = 0;
                ++row;
            }
            Quest quest = new Quest(chapter.file.newID(), chapter);
            quest.onCreated();
            quest.setX(col);
            quest.setY(row);
            quest.setRawSubtitle(stack2.m_41739_(new CompoundTag()).toString());
            new CreateObjectResponseMessage(quest, null).sendToAll(source.m_81377_());
            ItemTask task = new ItemTask(chapter.file.newID(), quest);
            task.onCreated();
            task.setStackAndCount(stack2, 1).setConsumeItems(Tristate.TRUE);
            CompoundTag extra = new CompoundTag();
            extra.m_128359_("type", task.getType().getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(source.m_81377_());
            ++col;
        }
        ServerQuestFile.INSTANCE.markDirty();
        ServerQuestFile.INSTANCE.saveNow();
        source.m_288197_(() -> Component.m_237113_((String)"Done!"), false);
        return 1;
    }

    private static int doReload(CommandSourceStack source) {
        UUID id;
        ServerQuestFile instance = ServerQuestFile.INSTANCE;
        ServerPlayer sender = source.m_230896_();
        if (sender != null && !instance.getOrCreateTeamData((Entity)sender).getCanEdit((Player)sender)) {
            source.m_81352_((Component)Component.m_237115_((String)"commands.ftbquests.command.error.not_editing"));
            return 0;
        }
        instance.load();
        new SyncQuestsMessage(instance).sendToAll(source.m_81377_());
        source.m_81377_().m_6846_().m_11314_().forEach(p -> new SyncEditorPermissionMessage(PermissionsHelper.hasEditorPermission(p, false)).sendTo((ServerPlayer)p));
        source.m_288197_(() -> Component.m_237115_((String)"commands.ftbquests.command.feedback.reloaded"), false);
        UUID uUID = id = sender == null ? Util.f_137441_ : sender.m_20148_();
        if (!warnedPlayers.contains(id)) {
            source.m_288197_(() -> Component.m_237115_((String)"commands.ftbquests.command.feedback.reloaded.disclaimer").m_130940_(ChatFormatting.GOLD), false);
            warnedPlayers.add(id);
        }
        return 1;
    }

    private static int toggleRewardBlocking(CommandSourceStack source, ServerPlayer player, Boolean doBlocking) {
        TeamData data = ServerQuestFile.INSTANCE.getOrCreateTeamData((Entity)player);
        if (doBlocking == null) {
            doBlocking = !data.areRewardsBlocked();
        }
        data.setRewardsBlocked(doBlocking);
        source.m_288197_(() -> Component.m_237110_((String)"commands.ftbquests.command.feedback.rewards_blocked", (Object[])new Object[]{data, data.areRewardsBlocked()}), false);
        return 1;
    }

    private static int clearDisplayCache(CommandSourceStack source) {
        ClearDisplayCacheMessage.clearForAll(source.m_81377_());
        source.m_288197_(() -> Component.m_237115_((String)"commands.ftbquests.command.feedback.clear_display_cache"), false);
        return 1;
    }
}

