/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.quests.CollectRewardsButton;
import dev.ftb.mods.ftbquests.client.gui.quests.EmergencyItemsButton;
import dev.ftb.mods.ftbquests.client.gui.quests.OpenGuidesButton;
import dev.ftb.mods.ftbquests.client.gui.quests.OpenShopButton;
import dev.ftb.mods.ftbquests.client.gui.quests.OtherButtonsPanel;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestKeyReferenceScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.TabButton;
import dev.ftb.mods.ftbquests.net.TogglePinnedMessage;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import net.minecraft.network.chat.Component;

public class OtherButtonsPanelTop
extends OtherButtonsPanel {
    public OtherButtonsPanelTop(Panel panel) {
        super(panel);
    }

    public void addWidgets() {
        this.add((Widget)new CollectRewardsButton(this));
        this.add((Widget)new AutopinButton(this));
        this.add((Widget)new KeyReferenceButton(this));
        if (Platform.isModLoaded((String)"ftbguides")) {
            this.add((Widget)new OpenGuidesButton(this));
        }
        if (!this.questScreen.file.getEmergencyItems().isEmpty() && (this.questScreen.file.selfTeamData != null || this.questScreen.file.canEdit())) {
            this.add((Widget)new EmergencyItemsButton(this));
        }
        if (!((String)ThemeProperties.WIKI_URL.get()).equals("-")) {
            this.add((Widget)new WikiButton(this));
        }
        if (Platform.isModLoaded((String)"ftbmoney")) {
            this.add((Widget)new OpenShopButton(this));
        }
    }

    public void alignWidgets() {
        this.setPosAndSize(this.questScreen.width - this.width, 1, this.width, this.align(WidgetLayout.VERTICAL));
    }

    public static class AutopinButton
    extends TabButton {
        public AutopinButton(Panel panel) {
            super(panel, (Component)Component.m_237115_((String)(AutopinButton.isAutoPin() ? "ftbquests.gui.autopin.on" : "ftbquests.gui.autopin.off")), AutopinButton.isAutoPin() ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.PIN_ICON_OFF.get());
        }

        private static boolean isAutoPin() {
            return ClientQuestFile.isQuestPinned(1L);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            new TogglePinnedMessage(1L).sendToServer();
        }
    }

    private static class KeyReferenceButton
    extends TabButton {
        public KeyReferenceButton(Panel panel) {
            super(panel, (Component)Component.m_237115_((String)"ftblibrary.gui.key_reference"), Icons.INFO_GRAY);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (ClientQuestFile.INSTANCE.canEdit()) {
                new QuestKeyReferenceScreen("ftbquests.gui.key_reference.player", "ftbquests.gui.key_reference.editor").openGui();
            } else {
                new QuestKeyReferenceScreen("ftbquests.gui.key_reference.player").openGui();
            }
        }
    }

    public static class WikiButton
    extends TabButton {
        public WikiButton(Panel panel) {
            super(panel, (Component)Component.m_237115_((String)"ftbquests.gui.wiki"), (Icon)ThemeProperties.WIKI_ICON.get());
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.handleClick((String)ThemeProperties.WIKI_URL.get());
        }
    }
}

