/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.block;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.handler.ConfigHandler;
import codechicken.translocators.init.TranslocatorsModContent;
import codechicken.translocators.tile.TileCraftingGrid;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockCraftingGrid
extends Block
implements EntityBlock {
    private static final IndexedVoxelShape BASE = new IndexedVoxelShape(new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.005, 1.0).shape(), (Object)0);
    private static final IndexedVoxelShape[][] BUTTONS = new IndexedVoxelShape[4][9];
    private static final VoxelShape[] SHAPES = new VoxelShape[4];

    public BlockCraftingGrid() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60955_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCraftingGrid(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != TranslocatorsModContent.tileCraftingGridType.get()) {
            return null;
        }
        return (level1, pos, state1, t) -> {
            if (!level1.f_46443_) {
                ((TileCraftingGrid)t).tickServer();
            }
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        IndexedVoxelShape shape = BASE;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileCraftingGrid) {
            TileCraftingGrid tile = (TileCraftingGrid)blockEntity;
            shape = SHAPES[tile.rotation];
        }
        return shape;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos beneath = pos.m_7495_();
        return world.m_8055_(beneath).m_60783_((BlockGetter)world, beneath, Direction.UP);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        TileCraftingGrid tcraft = (TileCraftingGrid)((Object)builder.m_287159_(LootContextParams.f_81462_));
        if (tcraft != null) {
            for (ItemStack item : tcraft.items) {
                if (item == null) continue;
                stacks.add(item.m_41777_());
            }
        }
        return stacks;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult blockHit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        TileCraftingGrid tcraft = (TileCraftingGrid)world.m_7702_(pos);
        if (blockHit instanceof SubHitBlockHitResult) {
            SubHitBlockHitResult hit = (SubHitBlockHitResult)blockHit;
            if (hit.subHit > 0) {
                tcraft.activate(hit.subHit - 1, player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean placeBlock(Level world, Player player, BlockPos pos, Direction side) {
        BlockHitResult hit;
        BlockPlaceContext ctx;
        if (ConfigHandler.disableCraftingGrid || side != Direction.UP) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (!state.m_60629_(ctx = new BlockPlaceContext(player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, hit = RayTracer.retrace((Player)player)))) {
            pos = pos.m_7494_();
        }
        if (!world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
            return false;
        }
        player.m_6674_(InteractionHand.MAIN_HAND);
        if (!world.m_46597_(pos, this.m_49966_())) {
            return false;
        }
        this.m_6402_(world, pos, this.m_49966_(), (LivingEntity)player, null);
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        ((TileCraftingGrid)world.m_7702_(pos)).onPlaced(placer);
    }

    static {
        for (int rot = 0; rot < 4; ++rot) {
            for (int b = 0; b < 9; ++b) {
                Cuboid6 box = new Cuboid6(0.0625, 0.0, 0.0625, 0.3125, 0.01, 0.3125).apply((Transformation)new Translation((double)(b % 3 * 5) / 16.0, 0.0, (double)(b / 3 * 5) / 16.0).with(Rotation.quarterRotations[rot].at(Vector3.CENTER)));
                BlockCraftingGrid.BUTTONS[rot][b] = new IndexedVoxelShape(box.shape(), (Object)(b + 1));
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add((Object)BASE);
            builder.add(BUTTONS[rot]);
            BlockCraftingGrid.SHAPES[rot] = new MultiIndexedVoxelShape((VoxelShape)BASE, builder.build());
        }
    }
}

