/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.rectangular;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.ICoreMultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IAxisPositionBlock;
import net.roguelogix.phosphophyllite.multiblock.validated.IAssemblyStateTileModule;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblockTile;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.BlockStates;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public interface IRectangularMultiblockTile<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IValidatedMultiblockTile<TileType, BlockType, ControllerType> {

    public static final class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends TileModule<TileType>
    implements ICoreMultiblockTileModule<TileType, BlockType, ControllerType>,
    IAssemblyStateTileModule {
        private final boolean AXIS_POSITIONS;
        private final boolean FACE_DIRECTION;

        @OnModLoad
        public static void register() {
            ModuleRegistry.registerTileModule(IRectangularMultiblockTile.class, Module::new);
        }

        public Module(IRectangularMultiblockTile<TileType, BlockType, ControllerType> iface) {
            super(iface);
            this.AXIS_POSITIONS = ((BlockEntity)this.iface).m_58900_().m_61138_(IAxisPositionBlock.AxisPosition.X_AXIS_POSITION);
            this.FACE_DIRECTION = ((BlockEntity)this.iface).m_58900_().m_61138_((Property)BlockStates.FACING);
        }

        @Override
        public BlockState assembledBlockState(BlockState state) {
            BlockPos pos;
            if (this.AXIS_POSITIONS) {
                pos = ((BlockEntity)this.iface).m_58899_();
                state = pos.m_123341_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).min().x() ? (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.X_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.LOWER)) : (pos.m_123341_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).max().x() ? (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.X_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.UPPER)) : (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.X_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.MIDDLE)));
                state = pos.m_123342_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).min().y() ? (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.Y_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.LOWER)) : (pos.m_123342_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).max().y() ? (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.Y_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.UPPER)) : (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.Y_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.MIDDLE)));
                state = pos.m_123343_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).min().z() ? (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.Z_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.LOWER)) : (pos.m_123343_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).max().z() ? (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.Z_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.UPPER)) : (BlockState)state.m_61124_(IAxisPositionBlock.AxisPosition.Z_AXIS_POSITION, (Comparable)((Object)IAxisPositionBlock.AxisPosition.MIDDLE)));
            }
            if (this.FACE_DIRECTION) {
                pos = ((BlockEntity)this.iface).m_58899_();
                if (pos.m_123341_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).min().x()) {
                    state = (BlockState)state.m_61124_((Property)BlockStates.FACING, (Comparable)Direction.WEST);
                } else if (pos.m_123341_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).max().x()) {
                    state = (BlockState)state.m_61124_((Property)BlockStates.FACING, (Comparable)Direction.EAST);
                } else if (pos.m_123342_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).min().y()) {
                    state = (BlockState)state.m_61124_((Property)BlockStates.FACING, (Comparable)Direction.DOWN);
                } else if (pos.m_123342_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).max().y()) {
                    state = (BlockState)state.m_61124_((Property)BlockStates.FACING, (Comparable)Direction.UP);
                } else if (pos.m_123343_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).min().z()) {
                    state = (BlockState)state.m_61124_((Property)BlockStates.FACING, (Comparable)Direction.NORTH);
                } else if (pos.m_123343_() == ((MultiblockController)((IMultiblockTile)((BlockEntity)this.iface)).controller()).max().z()) {
                    state = (BlockState)state.m_61124_((Property)BlockStates.FACING, (Comparable)Direction.SOUTH);
                }
            }
            return state;
        }

        @Override
        public BlockState disassembledBlockState(BlockState state) {
            return state;
        }
    }
}

