/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.debug.IDebuggable;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockRegistry;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.modular.IModularMultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.util.AStarList;
import net.roguelogix.phosphophyllite.util.ModuleMap;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;
import net.roguelogix.phosphophyllite.util.VectorUtil;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@NonnullDefault
public class MultiblockController<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
implements IModularMultiblockController<TileType, BlockType, ControllerType>,
IDebuggable {
    public final Level level;
    public final ModuleMap<MultiblockTileModule<TileType, BlockType, ControllerType>, TileType> blocks = new ModuleMap((TileModule[])new MultiblockTileModule[0]);
    public final Predicate<BlockEntity> tileTypeValidator;
    public final Predicate<Block> blockTypeValidator;
    private boolean updateExtremes = true;
    private final Vector3i minCoord = new Vector3i();
    private final Vector3i maxCoord = new Vector3i();
    private final Vector3i minExtremeBlocks = new Vector3i();
    private final Vector3i maxExtremeBlocks = new Vector3i();
    private long lastTick = -1L;
    private long checkForDetachmentsAtTick = Long.MAX_VALUE;
    protected final List<Detachment> removedBlocks = new LinkedList<Detachment>();
    @Nullable
    private MultiblockController<TileType, BlockType, ControllerType> mergedInto = null;
    protected final Set<MultiblockController<TileType, BlockType, ControllerType>> controllersToMerge = new ObjectOpenHashSet();
    private final Reference2ReferenceArrayMap<Class<?>, MultiblockControllerModule<TileType, BlockType, ControllerType>> modules = new Reference2ReferenceArrayMap();
    private final List<MultiblockControllerModule<TileType, BlockType, ControllerType>> moduleListRO;

    public MultiblockController(Level level, Class<TileType> tileType, Class<BlockType> blockType) {
        this.level = level;
        this.tileTypeValidator = tileType::isInstance;
        this.blockTypeValidator = blockType::isInstance;
        MultiblockRegistry.addController(this);
        ArrayList moduleList = new ArrayList();
        this.moduleListRO = Collections.unmodifiableList(moduleList);
        Class<?> thisClazz = this.getClass();
        MultiblockControllerModuleRegistry.forEach((clazz, constructor) -> {
            if (clazz.isAssignableFrom(thisClazz)) {
                MultiblockControllerModule module = (MultiblockControllerModule)constructor.apply(this);
                this.modules.put(clazz, (Object)module);
                moduleList.add(module);
            }
        });
        this.moduleListRO.forEach(MultiblockControllerModule::postModuleConstruction);
    }

    ControllerType self() {
        return (ControllerType)this;
    }

    public final Vector3ic min() {
        return this.minCoord;
    }

    public final Vector3ic max() {
        return this.maxCoord;
    }

    @Override
    @Nullable
    public MultiblockControllerModule<TileType, BlockType, ControllerType> module(Class<?> interfaceClazz) {
        return (MultiblockControllerModule)this.modules.get(interfaceClazz);
    }

    @Override
    public List<MultiblockControllerModule<TileType, BlockType, ControllerType>> modules() {
        return this.moduleListRO;
    }

    @Nullable
    public MultiblockTileModule<TileType, BlockType, ControllerType> tileModule(int x, int y, int z) {
        return this.blocks.getModule(x, y, z);
    }

    @Nullable
    public TileType tileEntity(int x, int y, int z) {
        return this.blocks.getTile(x, y, z);
    }

    public TileType randomTile() {
        return (TileType)((BlockEntity)Objects.requireNonNull(this.blocks.getOne()).iface);
    }

    @Contract(pure=true)
    public boolean canAttachTile(IMultiblockTile<?, ?, ?> tile) {
        return this.tileTypeValidator.test((BlockEntity)tile);
    }

    public void attemptAttach(@Nonnull MultiblockTileModule<?, ?, ?> toAttachGeneric) {
        this.attemptAttach(toAttachGeneric, false);
    }

    public void attemptAttach(@Nonnull MultiblockTileModule<?, ?, ?> toAttachGeneric, boolean merging) {
        if (!this.canAttachTile((IMultiblockTile)toAttachGeneric.iface)) {
            return;
        }
        MultiblockTileModule<?, ?, ?> toAttachModule = toAttachGeneric;
        BlockEntity toAttachTile = (BlockEntity)toAttachModule.iface;
        for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
            if (multiblockControllerModule.canAttachPart(toAttachTile)) continue;
            return;
        }
        if (toAttachModule.controller() != null && toAttachModule.controller() != this) {
            if (((MultiblockController)toAttachModule.controller()).blocks.size() > this.blocks.size()) {
                ((MultiblockController)toAttachModule.controller()).controllersToMerge.add((MultiblockController<TileType, BlockType, ControllerType>)this.self());
            } else {
                this.controllersToMerge.add((MultiblockController<TileType, BlockType, ControllerType>)toAttachModule.controller());
            }
            return;
        }
        if (toAttachModule.controller() == this) {
            return;
        }
        toAttachModule.controller(this.self());
        if (!this.blocks.addModule(toAttachModule)) {
            return;
        }
        BlockPos toAttachPos = toAttachTile.m_58899_();
        if (toAttachPos.m_123341_() < this.minCoord.x) {
            this.minCoord.x = toAttachPos.m_123341_();
            this.minExtremeBlocks.x = 1;
        } else if (toAttachPos.m_123341_() == this.minCoord.x) {
            ++this.minExtremeBlocks.x;
        }
        if (toAttachPos.m_123342_() < this.minCoord.y) {
            this.minCoord.y = toAttachPos.m_123342_();
            this.minExtremeBlocks.y = 1;
        } else if (toAttachPos.m_123342_() == this.minCoord.y) {
            ++this.minExtremeBlocks.y;
        }
        if (toAttachPos.m_123343_() < this.minCoord.z) {
            this.minCoord.z = toAttachPos.m_123343_();
            this.minExtremeBlocks.z = 1;
        } else if (toAttachPos.m_123343_() == this.minCoord.z) {
            ++this.minExtremeBlocks.z;
        }
        if (toAttachPos.m_123341_() > this.maxCoord.x) {
            this.maxCoord.x = toAttachPos.m_123341_();
            this.maxExtremeBlocks.x = 1;
        } else if (toAttachPos.m_123341_() == this.maxCoord.x) {
            ++this.maxExtremeBlocks.x;
        }
        if (toAttachPos.m_123342_() > this.maxCoord.y) {
            this.maxCoord.y = toAttachPos.m_123342_();
            this.maxExtremeBlocks.y = 1;
        } else if (toAttachPos.m_123342_() == this.maxCoord.y) {
            ++this.maxExtremeBlocks.y;
        }
        if (toAttachPos.m_123343_() > this.maxCoord.z) {
            this.maxCoord.z = toAttachPos.m_123343_();
            this.maxExtremeBlocks.z = 1;
        } else if (toAttachPos.m_123343_() == this.maxCoord.z) {
            ++this.maxExtremeBlocks.z;
        }
        for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
            multiblockControllerModule.onPartAdded(toAttachTile);
        }
        this.onPartAdded(toAttachTile);
        if (merging) {
            for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
                multiblockControllerModule.onPartAttached(toAttachTile);
            }
            this.onPartAttached(toAttachTile);
        } else if (toAttachModule.preExistingBlock) {
            for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
                multiblockControllerModule.onPartLoaded(toAttachTile);
            }
            this.onPartLoaded(toAttachTile);
        } else {
            for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
                multiblockControllerModule.onPartPlaced(toAttachTile);
            }
            this.onPartPlaced(toAttachTile);
        }
        toAttachModule.updateNeighbors();
    }

    public void detach(@Nonnull MultiblockTileModule<TileType, BlockType, ControllerType> toDetachModule, boolean chunkUnload, boolean merging, boolean checkForDetachments) {
        if (!this.blocks.removeModule(toDetachModule)) {
            return;
        }
        BlockEntity toDetachTile = (BlockEntity)toDetachModule.iface;
        if (merging) {
            for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
                multiblockControllerModule.onPartDetached(toDetachTile);
            }
            this.onPartDetached(toDetachTile);
        } else if (chunkUnload) {
            for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
                multiblockControllerModule.onPartUnloaded(toDetachTile);
            }
            this.onPartUnloaded(toDetachTile);
        } else {
            for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
                multiblockControllerModule.onPartBroken(toDetachTile);
            }
            this.onPartBroken(toDetachTile);
        }
        for (MultiblockControllerModule<BlockEntity, BlockType, ControllerType> multiblockControllerModule : this.modules()) {
            multiblockControllerModule.onPartRemoved(toDetachTile);
        }
        this.onPartRemoved(toDetachTile);
        BlockPos toDetachPos = toDetachTile.m_58899_();
        if (toDetachPos.m_123341_() == this.minCoord.x) {
            --this.minExtremeBlocks.x;
            if (this.minExtremeBlocks.x == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123342_() == this.minCoord.y) {
            --this.minExtremeBlocks.y;
            if (this.minExtremeBlocks.y == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123343_() == this.minCoord.z) {
            --this.minExtremeBlocks.z;
            if (this.minExtremeBlocks.z == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123341_() == this.maxCoord.x) {
            --this.maxExtremeBlocks.x;
            if (this.maxExtremeBlocks.x == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123342_() == this.maxCoord.y) {
            --this.maxExtremeBlocks.y;
            if (this.maxExtremeBlocks.y == 0) {
                this.updateExtremes = true;
            }
        }
        if (toDetachPos.m_123343_() == this.maxCoord.z) {
            --this.maxExtremeBlocks.z;
            if (this.maxExtremeBlocks.z == 0) {
                this.updateExtremes = true;
            }
        }
        if (checkForDetachments) {
            this.checkForDetachmentsAtTick = Phosphophyllite.tickNumber() + 2L;
            if (!chunkUnload) {
                this.checkForDetachmentsAtTick = Long.MIN_VALUE;
            }
            this.removedBlocks.add(new Detachment(toDetachPos, toDetachModule.neighborTiles));
        }
        if (!merging) {
            toDetachModule.nullNeighbors();
        }
        toDetachModule.controller(null);
    }

    private void updateMinMaxCoordinates() {
        if (this.blocks.isEmpty() || !this.updateExtremes) {
            return;
        }
        this.updateExtremes = false;
        this.minCoord.set(Integer.MAX_VALUE);
        this.maxCoord.set(Integer.MIN_VALUE);
        this.blocks.forEachPos(pos -> {
            if (pos.m_123341_() < this.minCoord.x) {
                this.minCoord.x = pos.m_123341_();
                this.minExtremeBlocks.x = 1;
            } else if (pos.m_123341_() == this.minCoord.x) {
                ++this.minExtremeBlocks.x;
            }
            if (pos.m_123342_() < this.minCoord.y) {
                this.minCoord.y = pos.m_123342_();
                this.minExtremeBlocks.y = 1;
            } else if (pos.m_123342_() == this.minCoord.y) {
                ++this.minExtremeBlocks.y;
            }
            if (pos.m_123343_() < this.minCoord.z) {
                this.minCoord.z = pos.m_123343_();
                this.minExtremeBlocks.z = 1;
            } else if (pos.m_123343_() == this.minCoord.z) {
                ++this.minExtremeBlocks.z;
            }
            if (pos.m_123341_() > this.maxCoord.x) {
                this.maxCoord.x = pos.m_123341_();
                this.maxExtremeBlocks.x = 1;
            } else if (pos.m_123341_() == this.maxCoord.x) {
                ++this.maxExtremeBlocks.x;
            }
            if (pos.m_123342_() > this.maxCoord.y) {
                this.maxCoord.y = pos.m_123342_();
                this.maxExtremeBlocks.y = 1;
            } else if (pos.m_123342_() == this.maxCoord.y) {
                ++this.maxExtremeBlocks.y;
            }
            if (pos.m_123343_() > this.maxCoord.z) {
                this.maxCoord.z = pos.m_123343_();
                this.maxExtremeBlocks.z = 1;
            } else if (pos.m_123343_() == this.maxCoord.z) {
                ++this.maxExtremeBlocks.z;
            }
        });
    }

    private void processDetachments() {
        if (this.checkForDetachmentsAtTick > Phosphophyllite.tickNumber()) {
            return;
        }
        this.checkForDetachmentsAtTick = Long.MAX_VALUE;
        AStarList<MultiblockTileModule> aStarList = new AStarList<MultiblockTileModule>(module -> ((BlockEntity)module.iface).m_58899_());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Detachment removedBlock : this.removedBlocks) {
            for (Direction value : Util.DIRECTIONS) {
                if (!removedBlock.linked(value)) continue;
                mutableBlockPos.m_122190_((Vec3i)removedBlock.pos);
                mutableBlockPos.m_122173_(value);
                MultiblockTileModule<TileType, BlockType, ControllerType> module2 = this.blocks.getModule((BlockPos)mutableBlockPos);
                if (module2 == null || module2.controller() != this) continue;
                aStarList.addTarget(module2);
            }
        }
        this.removedBlocks.clear();
        while (!aStarList.done()) {
            MultiblockTileModule node = aStarList.nextNode();
            for (int i = 0; i < 6; ++i) {
                node.lastSavedTick = this.lastTick;
                MultiblockTileModule module3 = node.getNeighbor(Util.DIRECTIONS[i]);
                if (module3 == null || module3.controller() != this || module3.lastSavedTick == this.lastTick) continue;
                module3.lastSavedTick = this.lastTick;
                aStarList.addNode(module3);
            }
        }
        if (aStarList.foundAll()) {
            return;
        }
        ObjectOpenHashSet toOrphan = new ObjectOpenHashSet();
        this.blocks.forEachModule(module -> {
            if (module.lastSavedTick != this.lastTick) {
                toOrphan.add(module);
            }
        });
        if (toOrphan.isEmpty()) {
            return;
        }
        for (MultiblockTileModule tile : toOrphan) {
            this.detach(tile, false, true, false);
        }
        ObjectArrayList newMultiblocks = new ObjectArrayList();
        ObjectArrayList tempModuleArrays = new ObjectArrayList();
        ObjectOpenHashSet newMultiblockModules = new ObjectOpenHashSet();
        while (!toOrphan.isEmpty()) {
            MultiblockTileModule first = (MultiblockTileModule)toOrphan.iterator().next();
            tempModuleArrays.add((Object)first);
            toOrphan.remove((Object)first);
            while (!tempModuleArrays.isEmpty()) {
                MultiblockTileModule popped = (MultiblockTileModule)tempModuleArrays.pop();
                newMultiblockModules.add((Object)popped);
                toOrphan.remove((Object)popped);
                for (MultiblockTileModule neighbor : popped.neighbors) {
                    if (neighbor == null || newMultiblockModules.contains(neighbor)) continue;
                    tempModuleArrays.add(neighbor);
                }
            }
            Object newController = ((IMultiblockTile)((BlockEntity)first.iface)).createController();
            for (MultiblockTileModule newMultiblockModule : newMultiblockModules) {
                ((MultiblockController)newController).attemptAttach(newMultiblockModule, true);
            }
            newMultiblockModules.clear();
            newMultiblocks.add(newController);
        }
        for (MultiblockControllerModule<TileType, BlockType, ControllerType> module4 : this.modules()) {
            module4.split((List<ControllerType>)newMultiblocks);
        }
        this.split((List<ControllerType>)newMultiblocks);
    }

    private void processMerges() {
        while (!this.controllersToMerge.isEmpty()) {
            ObjectOpenHashSet newToMerge = new ObjectOpenHashSet();
            Iterator<MultiblockController<TileType, BlockType, ControllerType>> iterator = this.controllersToMerge.iterator();
            while (iterator.hasNext()) {
                MultiblockController<TileType, BlockType, ControllerType> otherController;
                MultiblockController<TileType, BlockType, ControllerType> otherCased = otherController = iterator.next();
                MultiblockRegistry.removeController(otherController);
                otherController.controllersToMerge.remove(this.self());
                newToMerge.addAll(otherController.controllersToMerge);
                otherController.controllersToMerge.clear();
                if (otherController.mergedInto != null && otherController.mergedInto != this) {
                    newToMerge.add(otherController.mergedInto);
                    otherController.mergedInto.controllersToMerge.add(this);
                    continue;
                }
                if (otherController.blocks.size() == 0) continue;
                for (MultiblockControllerModule<TileType, BlockType, MultiblockController<TileType, BlockType, ControllerType>> multiblockControllerModule : this.modules()) {
                    multiblockControllerModule.merge(otherCased);
                }
                this.merge(otherCased);
                MultiblockTileModule[] otherElements = (MultiblockTileModule[])((MultiblockTileModule[])otherController.blocks.moduleElements()).clone();
                int n = otherController.blocks.size();
                for (int i = 0; i < n; ++i) {
                    MultiblockTileModule module = otherElements[i];
                    otherController.detach(module, false, true, false);
                    module.controller(null);
                    module.preExistingBlock = true;
                    this.attemptAttach(module, true);
                }
                otherController.blocks.clear();
                otherController.mergedInto = this;
            }
            this.controllersToMerge.clear();
            this.controllersToMerge.addAll((Collection<MultiblockController<TileType, BlockType, ControllerType>>)newToMerge);
        }
    }

    public final void suicide() {
        if (this.blocks.isEmpty()) {
            return;
        }
        ModuleMap blocks = new ModuleMap((TileModule[])new MultiblockTileModule[0]);
        blocks.addAll(this.blocks);
        blocks.forEachModule(module -> module.onRemoved(true));
        MultiblockRegistry.removeController(this);
    }

    public final void update() {
        if (this.lastTick >= Phosphophyllite.tickNumber()) {
            return;
        }
        this.lastTick = Phosphophyllite.tickNumber();
        if (this.blocks.isEmpty()) {
            MultiblockRegistry.removeController(this);
            this.checkForDetachmentsAtTick = Long.MAX_VALUE;
            return;
        }
        this.processDetachments();
        this.processMerges();
        this.updateMinMaxCoordinates();
        this.modules().forEach(MultiblockControllerModule::update);
    }

    @Nullable
    public DebugInfo getControllerDebugInfo() {
        return null;
    }

    @Override
    @Nonnull
    public final DebugInfo getDebugInfo() {
        DebugInfo debugInfo = new DebugInfo("MultiblockController");
        debugInfo.add("Controller class: " + this.getClass().getCanonicalName().substring(this.getClass().getPackageName().length() + 1));
        debugInfo.add("Controller hash:  " + Integer.toHexString(this.hashCode()));
        debugInfo.add("BlockCount: " + this.blocks.size());
        debugInfo.add("Min: " + VectorUtil.asString((Vector3ic)this.minCoord));
        debugInfo.add("Max: " + VectorUtil.asString((Vector3ic)this.maxCoord));
        debugInfo.add("Size: " + VectorUtil.asString((Vector3ic)new Vector3i(1, 1, 1).add((Vector3ic)this.maxCoord).sub((Vector3ic)this.minCoord)));
        for (Map.Entry moduleEntry : this.modules.entrySet()) {
            DebugInfo moduleDebugInfo = ((MultiblockControllerModule)moduleEntry.getValue()).getDebugInfo();
            if (moduleDebugInfo == null) {
                debugInfo.add(new DebugInfo(((Class)moduleEntry.getKey()).getSimpleName()));
                continue;
            }
            debugInfo.add(moduleDebugInfo);
        }
        debugInfo.add(this.getControllerDebugInfo());
        return debugInfo;
    }

    protected void onPartAdded(@Nonnull TileType tile) {
    }

    protected void onPartRemoved(@Nonnull TileType tile) {
    }

    protected void onPartLoaded(@Nonnull TileType tile) {
    }

    protected void onPartUnloaded(@Nonnull TileType tile) {
    }

    protected void onPartAttached(@Nonnull TileType tile) {
    }

    protected void onPartDetached(@Nonnull TileType tile) {
    }

    protected void onPartPlaced(@Nonnull TileType tile) {
    }

    protected void onPartBroken(@Nonnull TileType tile) {
    }

    protected void merge(ControllerType other) {
    }

    protected void split(List<ControllerType> others) {
    }

    private record Detachment(BlockPos pos, byte directions) {
        Detachment(BlockPos pos, BlockEntity[] neighbors) {
            this(pos, Detachment.arrayToByte(neighbors));
        }

        public boolean linked(Direction direction) {
            return (this.directions & 1 << direction.m_122411_()) != 0;
        }

        private static byte arrayToByte(BlockEntity[] neighbors) {
            byte directions = 0;
            for (int i = 0; i < neighbors.length; ++i) {
                if (neighbors[i] == null) continue;
                directions = (byte)(directions | 1 << i);
            }
            return directions;
        }
    }
}

