/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import java.lang.reflect.Field;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.config.spec.SpecValueNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class SpecStringNode
extends SpecValueNode {
    public final String defaultString = this.currentValueAsString();

    SpecStringNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(parent, field, defaults);
    }

    @Override
    public String defaultValueAsString() {
        return this.defaultString;
    }

    @Override
    public String currentValueAsString() {
        return (String)this.currentValueObject();
    }

    @Override
    public void writeFromString(String string) {
        this.writeObject(string);
    }

    @Override
    public boolean isValueValid(String valueString) {
        return true;
    }

    @Override
    public void writeDefault() {
        this.writeFromString(this.defaultString);
    }

    @Override
    public Element generateDefaultElement() {
        return new Element(Element.Type.String, this.generateComment(), this.name, this.defaultString);
    }

    @Override
    public Element generateCurrentElement() {
        return new Element(Element.Type.String, this.generateComment(), this.name, this.currentValueAsString());
    }

    @Override
    public Element generateSyncElement() {
        return new Element(Element.Type.String, null, this.name, this.currentValueAsString());
    }

    @Override
    public String generateComment() {
        return this.baseComment;
    }

    @Override
    public Element correctToValidState(Element element) {
        if (element.type == Element.Type.String && element.value instanceof String) {
            return new Element(Element.Type.String, this.baseComment, this.name, element.value);
        }
        return this.generateDefaultElement();
    }

    @Override
    public void writeElement(Element element) {
        this.writeFromString(element.asString());
    }
}

