/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.config.spec.SpecValueNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class SpecEnumNode
extends SpecValueNode {
    public final Class<?> enumClass;
    public final Enum<?> defaultValue;
    public final List<Enum<?>> allowedValues;

    SpecEnumNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(parent, field, defaults);
        this.enumClass = field.getType();
        this.defaultValue = this.currentValue();
        ConfigValue annotation = field.getAnnotation(ConfigValue.class);
        ObjectArrayList allowedValues = new ObjectArrayList();
        for (String value : annotation.allowedValues()) {
            if (value.equalsIgnoreCase("null")) {
                allowedValues.add(null);
            }
            for (Object enumVal : this.enumClass.getEnumConstants()) {
                if (!enumVal.toString().equalsIgnoreCase(value)) continue;
                allowedValues.add((Object)((Enum)enumVal));
            }
        }
        if (allowedValues.isEmpty()) {
            allowedValues.add(null);
            for (String value : this.enumClass.getEnumConstants()) {
                allowedValues.add((Object)((Enum)((Object)value)));
            }
        }
        this.allowedValues = Collections.unmodifiableList(allowedValues);
    }

    @Override
    public String defaultValueAsString() {
        return String.valueOf(this.defaultValue);
    }

    public List<String> allowedValuesAsStrings() {
        return this.allowedValues.stream().map(String::valueOf).toList();
    }

    public Enum<?> currentValue() {
        return (Enum)this.currentValueObject();
    }

    @Override
    public String currentValueAsString() {
        return String.valueOf(this.currentValueObject());
    }

    @Override
    public void writeFromString(String string) {
        Enum<?> enumToWrite = this.currentValue();
        for (Enum<?> value : this.allowedValues) {
            if (!String.valueOf(value).equalsIgnoreCase(string)) continue;
            enumToWrite = value;
            break;
        }
        this.writeObject(enumToWrite);
    }

    @Override
    public boolean isValueValid(String valueString) {
        for (Enum<?> value : this.allowedValues) {
            if (!String.valueOf(value).equalsIgnoreCase(valueString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeDefault() {
        this.writeObject(this.defaultValue);
    }

    @Override
    public Element generateDefaultElement() {
        return new Element(Element.Type.String, this.generateComment(), this.name, String.valueOf(this.defaultValue));
    }

    @Override
    public Element generateCurrentElement() {
        return new Element(Element.Type.String, this.generateComment(), this.name, this.currentValueAsString());
    }

    @Override
    public Element generateSyncElement() {
        return new Element(Element.Type.String, null, this.name, this.currentValueAsString());
    }

    @Override
    public String generateComment() {
        StringBuilder comment = new StringBuilder(this.baseComment);
        if (comment.length() != 0) {
            comment.append('\n');
        }
        comment.append("Default: ");
        comment.append(this.defaultValue);
        comment.append("\nAllowed Values: ");
        for (String value : this.allowedValuesAsStrings()) {
            comment.append(value);
            comment.append(", ");
        }
        return comment.toString();
    }

    @Override
    public Element correctToValidState(Element element) {
        if (element.type != Element.Type.String || !(element.value instanceof String)) {
            return this.generateDefaultElement();
        }
        if (!this.isValueValid(element.asString())) {
            return this.generateDefaultElement();
        }
        return new Element(Element.Type.String, Objects.requireNonNull(this.generateDefaultElement()).comment, this.name, element.value);
    }

    @Override
    public void writeElement(Element element) {
        this.writeFromString(element.asString());
    }
}

